/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LoggingLevel {
    ERROR("ERROR"),
    INFO("INFO"),
    OFF("OFF"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LoggingLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoggingLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LoggingLevel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoggingLevel> knownValues() {
        return Stream.of(LoggingLevel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

