/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.Citation;
import software.amazon.awssdk.services.iotsitewise.model.CitationsCopier;
import software.amazon.awssdk.services.iotsitewise.model.InvokeAssistantResponseHandler;
import software.amazon.awssdk.services.iotsitewise.model.ResponseStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvocationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationOutput>,
ResponseStream {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(InvocationOutput.getter(InvocationOutput::message)).setter(InvocationOutput.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("citations").getter(InvocationOutput.getter(InvocationOutput::citations)).setter(InvocationOutput.setter(Builder::citations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Citation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, CITATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvocationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String message;
    private final List<Citation> citations;

    protected InvocationOutput(BuilderImpl builder) {
        this.message = builder.message;
        this.citations = builder.citations;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasCitations() {
        return this.citations != null && !(this.citations instanceof SdkAutoConstructList);
    }

    public final List<Citation> citations() {
        return this.citations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCitations() ? this.citations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationOutput)) {
            return false;
        }
        InvocationOutput other = (InvocationOutput)obj;
        return Objects.equals(this.message(), other.message()) && this.hasCitations() == other.hasCitations() && Objects.equals(this.citations(), other.citations());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationOutput").add("Message", (Object)this.message()).add("Citations", this.hasCitations() ? this.citations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "citations": {
                return Optional.ofNullable(clazz.cast(this.citations()));
            }
        }
        return Optional.empty();
    }

    public final InvocationOutput copy(Consumer<? super Builder> modifier) {
        return (InvocationOutput)super.copy(modifier);
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("message", MESSAGE_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationOutput, T> g) {
        return obj -> g.apply((InvocationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    @Override
    public void accept(InvokeAssistantResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    protected static class BuilderImpl
    implements Builder {
        private String message;
        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(InvocationOutput model) {
            this.message(model.message);
            this.citations(model.citations);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation ... citations) {
            this.citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder> ... citations) {
            this.citations(Stream.of(citations).map(c -> (Citation)((Citation.Builder)Citation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InvocationOutput build() {
            return new InvocationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationOutput> {
        public Builder message(String var1);

        public Builder citations(Collection<Citation> var1);

        public Builder citations(Citation ... var1);

        public Builder citations(Consumer<Citation.Builder> ... var1);
    }
}

