/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;

public class ListAssetModelsPublisher
implements SdkPublisher<ListAssetModelsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAssetModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetModelsPublisher(IoTSiteWiseAsyncClient client, ListAssetModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetModelsPublisher(IoTSiteWiseAsyncClient client, ListAssetModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetModelSummary> assetModelSummaries() {
        Function<ListAssetModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelSummaries() != null) {
                return response.assetModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetModelsResponseFetcher
    implements AsyncPageFetcher<ListAssetModelsResponse> {
        private ListAssetModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetModelsResponse> nextPage(ListAssetModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelsPublisher.this.client.listAssetModels(ListAssetModelsPublisher.this.firstRequest);
            }
            return ListAssetModelsPublisher.this.client.listAssetModels((ListAssetModelsRequest)((Object)ListAssetModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

