/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.CompositionRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse;

public class ListCompositionRelationshipsIterable
implements SdkIterable<ListCompositionRelationshipsResponse> {
    private final IoTSiteWiseClient client;
    private final ListCompositionRelationshipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCompositionRelationshipsIterable(IoTSiteWiseClient client, ListCompositionRelationshipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCompositionRelationshipsResponseFetcher();
    }

    public Iterator<ListCompositionRelationshipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CompositionRelationshipSummary> compositionRelationshipSummaries() {
        Function<ListCompositionRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.compositionRelationshipSummaries() != null) {
                return response.compositionRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCompositionRelationshipsResponseFetcher
    implements SyncPageFetcher<ListCompositionRelationshipsResponse> {
        private ListCompositionRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompositionRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCompositionRelationshipsResponse nextPage(ListCompositionRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListCompositionRelationshipsIterable.this.client.listCompositionRelationships(ListCompositionRelationshipsIterable.this.firstRequest);
            }
            return ListCompositionRelationshipsIterable.this.client.listCompositionRelationships((ListCompositionRelationshipsRequest)((Object)ListCompositionRelationshipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

