/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;

public class SearchFlowTemplatesPublisher
implements SdkPublisher<SearchFlowTemplatesResponse> {
    private final IoTThingsGraphAsyncClient client;
    private final SearchFlowTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchFlowTemplatesPublisher(IoTThingsGraphAsyncClient client, SearchFlowTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchFlowTemplatesPublisher(IoTThingsGraphAsyncClient client, SearchFlowTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchFlowTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchFlowTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FlowTemplateSummary> summaries() {
        Function<SearchFlowTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchFlowTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchFlowTemplatesResponseFetcher
    implements AsyncPageFetcher<SearchFlowTemplatesResponse> {
        private SearchFlowTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(SearchFlowTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchFlowTemplatesResponse> nextPage(SearchFlowTemplatesResponse previousPage) {
            if (previousPage == null) {
                return SearchFlowTemplatesPublisher.this.client.searchFlowTemplates(SearchFlowTemplatesPublisher.this.firstRequest);
            }
            return SearchFlowTemplatesPublisher.this.client.searchFlowTemplates((SearchFlowTemplatesRequest)((Object)SearchFlowTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

