/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendraranking.KendraRankingAsyncClient;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansRequest;
import software.amazon.awssdk.services.kendraranking.model.ListRescoreExecutionPlansResponse;

public class ListRescoreExecutionPlansPublisher
implements SdkPublisher<ListRescoreExecutionPlansResponse> {
    private final KendraRankingAsyncClient client;
    private final ListRescoreExecutionPlansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRescoreExecutionPlansPublisher(KendraRankingAsyncClient client, ListRescoreExecutionPlansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRescoreExecutionPlansPublisher(KendraRankingAsyncClient client, ListRescoreExecutionPlansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRescoreExecutionPlansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRescoreExecutionPlansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRescoreExecutionPlansResponseFetcher
    implements AsyncPageFetcher<ListRescoreExecutionPlansResponse> {
        private ListRescoreExecutionPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListRescoreExecutionPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRescoreExecutionPlansResponse> nextPage(ListRescoreExecutionPlansResponse previousPage) {
            if (previousPage == null) {
                return ListRescoreExecutionPlansPublisher.this.client.listRescoreExecutionPlans(ListRescoreExecutionPlansPublisher.this.firstRequest);
            }
            return ListRescoreExecutionPlansPublisher.this.client.listRescoreExecutionPlans((ListRescoreExecutionPlansRequest)((Object)ListRescoreExecutionPlansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

