/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendraranking.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRescoreExecutionPlansResponse extends KendraRankingResponse implements
        ToCopyableBuilder<ListRescoreExecutionPlansResponse.Builder, ListRescoreExecutionPlansResponse> {
    private static final SdkField<List<RescoreExecutionPlanSummary>> SUMMARY_ITEMS_FIELD = SdkField
            .<List<RescoreExecutionPlanSummary>> builder(MarshallingType.LIST)
            .memberName("SummaryItems")
            .getter(getter(ListRescoreExecutionPlansResponse::summaryItems))
            .setter(setter(Builder::summaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RescoreExecutionPlanSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RescoreExecutionPlanSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRescoreExecutionPlansResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_ITEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RescoreExecutionPlanSummary> summaryItems;

    private final String nextToken;

    private ListRescoreExecutionPlansResponse(BuilderImpl builder) {
        super(builder);
        this.summaryItems = builder.summaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SummaryItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSummaryItems() {
        return summaryItems != null && !(summaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of summary information for one or more rescore execution plans.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSummaryItems} method.
     * </p>
     * 
     * @return An array of summary information for one or more rescore execution plans.
     */
    public final List<RescoreExecutionPlanSummary> summaryItems() {
        return summaryItems;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
     * </p>
     * 
     * @return If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the
     *         response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSummaryItems() ? summaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRescoreExecutionPlansResponse)) {
            return false;
        }
        ListRescoreExecutionPlansResponse other = (ListRescoreExecutionPlansResponse) obj;
        return hasSummaryItems() == other.hasSummaryItems() && Objects.equals(summaryItems(), other.summaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRescoreExecutionPlansResponse")
                .add("SummaryItems", hasSummaryItems() ? summaryItems() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SummaryItems":
            return Optional.ofNullable(clazz.cast(summaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRescoreExecutionPlansResponse, T> g) {
        return obj -> g.apply((ListRescoreExecutionPlansResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KendraRankingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRescoreExecutionPlansResponse> {
        /**
         * <p>
         * An array of summary information for one or more rescore execution plans.
         * </p>
         * 
         * @param summaryItems
         *        An array of summary information for one or more rescore execution plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(Collection<RescoreExecutionPlanSummary> summaryItems);

        /**
         * <p>
         * An array of summary information for one or more rescore execution plans.
         * </p>
         * 
         * @param summaryItems
         *        An array of summary information for one or more rescore execution plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summaryItems(RescoreExecutionPlanSummary... summaryItems);

        /**
         * <p>
         * An array of summary information for one or more rescore execution plans.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreExecutionPlanSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreExecutionPlanSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendraranking.model.RescoreExecutionPlanSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #summaryItems(List<RescoreExecutionPlanSummary>)}.
         * 
         * @param summaryItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendraranking.model.RescoreExecutionPlanSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summaryItems(java.util.Collection<RescoreExecutionPlanSummary>)
         */
        Builder summaryItems(Consumer<RescoreExecutionPlanSummary.Builder>... summaryItems);

        /**
         * <p>
         * If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the response.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Kendra Intelligent Ranking returns a pagination token in the
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KendraRankingResponse.BuilderImpl implements Builder {
        private List<RescoreExecutionPlanSummary> summaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRescoreExecutionPlansResponse model) {
            super(model);
            summaryItems(model.summaryItems);
            nextToken(model.nextToken);
        }

        public final List<RescoreExecutionPlanSummary.Builder> getSummaryItems() {
            List<RescoreExecutionPlanSummary.Builder> result = RescoreExecutionPlanSummaryListCopier
                    .copyToBuilder(this.summaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryItems(Collection<RescoreExecutionPlanSummary.BuilderImpl> summaryItems) {
            this.summaryItems = RescoreExecutionPlanSummaryListCopier.copyFromBuilder(summaryItems);
        }

        @Override
        public final Builder summaryItems(Collection<RescoreExecutionPlanSummary> summaryItems) {
            this.summaryItems = RescoreExecutionPlanSummaryListCopier.copy(summaryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(RescoreExecutionPlanSummary... summaryItems) {
            summaryItems(Arrays.asList(summaryItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryItems(Consumer<RescoreExecutionPlanSummary.Builder>... summaryItems) {
            summaryItems(Stream.of(summaryItems).map(c -> RescoreExecutionPlanSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRescoreExecutionPlansResponse build() {
            return new ListRescoreExecutionPlansResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
