/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.StreamModeDetails;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamSummary> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(StreamSummary.getter(StreamSummary::streamName)).setter(StreamSummary.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(StreamSummary.getter(StreamSummary::streamARN)).setter(StreamSummary.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamStatus").getter(StreamSummary.getter(StreamSummary::streamStatusAsString)).setter(StreamSummary.setter(Builder::streamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStatus").build()}).build();
    private static final SdkField<StreamModeDetails> STREAM_MODE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamModeDetails").getter(StreamSummary.getter(StreamSummary::streamModeDetails)).setter(StreamSummary.setter(Builder::streamModeDetails)).constructor(StreamModeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamModeDetails").build()}).build();
    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StreamCreationTimestamp").getter(StreamSummary.getter(StreamSummary::streamCreationTimestamp)).setter(StreamSummary.setter(Builder::streamCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, STREAM_STATUS_FIELD, STREAM_MODE_DETAILS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String streamName;
    private final String streamARN;
    private final String streamStatus;
    private final StreamModeDetails streamModeDetails;
    private final Instant streamCreationTimestamp;

    private StreamSummary(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.streamModeDetails = builder.streamModeDetails;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final StreamStatus streamStatus() {
        return StreamStatus.fromValue(this.streamStatus);
    }

    public final String streamStatusAsString() {
        return this.streamStatus;
    }

    public final StreamModeDetails streamModeDetails() {
        return this.streamModeDetails;
    }

    public final Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamModeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSummary)) {
            return false;
        }
        StreamSummary other = (StreamSummary)obj;
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.streamStatusAsString(), other.streamStatusAsString()) && Objects.equals(this.streamModeDetails(), other.streamModeDetails()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StreamSummary").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("StreamStatus", (Object)this.streamStatusAsString()).add("StreamModeDetails", (Object)this.streamModeDetails()).add("StreamCreationTimestamp", (Object)this.streamCreationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "StreamStatus": {
                return Optional.ofNullable(clazz.cast(this.streamStatusAsString()));
            }
            case "StreamModeDetails": {
                return Optional.ofNullable(clazz.cast(this.streamModeDetails()));
            }
            case "StreamCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.streamCreationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamStatus", STREAM_STATUS_FIELD);
        map.put("StreamModeDetails", STREAM_MODE_DETAILS_FIELD);
        map.put("StreamCreationTimestamp", STREAM_CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamSummary, T> g) {
        return obj -> g.apply((StreamSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String streamStatus;
        private StreamModeDetails streamModeDetails;
        private Instant streamCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSummary model) {
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.streamStatus(model.streamStatus);
            this.streamModeDetails(model.streamModeDetails);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamStatus() {
            return this.streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final StreamModeDetails.Builder getStreamModeDetails() {
            return this.streamModeDetails != null ? this.streamModeDetails.toBuilder() : null;
        }

        public final void setStreamModeDetails(StreamModeDetails.BuilderImpl streamModeDetails) {
            this.streamModeDetails = streamModeDetails != null ? streamModeDetails.build() : null;
        }

        @Override
        public final Builder streamModeDetails(StreamModeDetails streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public StreamSummary build() {
            return new StreamSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamSummary> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder streamStatus(String var1);

        public Builder streamStatus(StreamStatus var1);

        public Builder streamModeDetails(StreamModeDetails var1);

        default public Builder streamModeDetails(Consumer<StreamModeDetails.Builder> streamModeDetails) {
            return this.streamModeDetails((StreamModeDetails)((StreamModeDetails.Builder)StreamModeDetails.builder().applyMutation(streamModeDetails)).build());
        }

        public Builder streamCreationTimestamp(Instant var1);
    }
}

