/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationSystemRollbackConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.EnvironmentPropertyDescriptions;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfigurationDescriptionsCopier;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationConfigurationDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationConfigurationDescription> {
    private static final SdkField<SqlApplicationConfigurationDescription> SQL_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqlApplicationConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::sqlApplicationConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::sqlApplicationConfigurationDescription)).constructor(SqlApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlApplicationConfigurationDescription").build()}).build();
    private static final SdkField<ApplicationCodeConfigurationDescription> APPLICATION_CODE_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationCodeConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::applicationCodeConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::applicationCodeConfigurationDescription)).constructor(ApplicationCodeConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeConfigurationDescription").build()}).build();
    private static final SdkField<RunConfigurationDescription> RUN_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RunConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::runConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::runConfigurationDescription)).constructor(RunConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunConfigurationDescription").build()}).build();
    private static final SdkField<FlinkApplicationConfigurationDescription> FLINK_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlinkApplicationConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::flinkApplicationConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::flinkApplicationConfigurationDescription)).constructor(FlinkApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlinkApplicationConfigurationDescription").build()}).build();
    private static final SdkField<EnvironmentPropertyDescriptions> ENVIRONMENT_PROPERTY_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnvironmentPropertyDescriptions").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::environmentPropertyDescriptions)).setter(ApplicationConfigurationDescription.setter(Builder::environmentPropertyDescriptions)).constructor(EnvironmentPropertyDescriptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentPropertyDescriptions").build()}).build();
    private static final SdkField<ApplicationSnapshotConfigurationDescription> APPLICATION_SNAPSHOT_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSnapshotConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::applicationSnapshotConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::applicationSnapshotConfigurationDescription)).constructor(ApplicationSnapshotConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSnapshotConfigurationDescription").build()}).build();
    private static final SdkField<ApplicationSystemRollbackConfigurationDescription> APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationSystemRollbackConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::applicationSystemRollbackConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::applicationSystemRollbackConfigurationDescription)).constructor(ApplicationSystemRollbackConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSystemRollbackConfigurationDescription").build()}).build();
    private static final SdkField<List<VpcConfigurationDescription>> VPC_CONFIGURATION_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcConfigurationDescriptions").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::vpcConfigurationDescriptions)).setter(ApplicationConfigurationDescription.setter(Builder::vpcConfigurationDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfigurationDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ZeppelinApplicationConfigurationDescription> ZEPPELIN_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ZeppelinApplicationConfigurationDescription").getter(ApplicationConfigurationDescription.getter(ApplicationConfigurationDescription::zeppelinApplicationConfigurationDescription)).setter(ApplicationConfigurationDescription.setter(Builder::zeppelinApplicationConfigurationDescription)).constructor(ZeppelinApplicationConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZeppelinApplicationConfigurationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SQL_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, APPLICATION_CODE_CONFIGURATION_DESCRIPTION_FIELD, RUN_CONFIGURATION_DESCRIPTION_FIELD, FLINK_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD, ENVIRONMENT_PROPERTY_DESCRIPTIONS_FIELD, APPLICATION_SNAPSHOT_CONFIGURATION_DESCRIPTION_FIELD, APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_DESCRIPTION_FIELD, VPC_CONFIGURATION_DESCRIPTIONS_FIELD, ZEPPELIN_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationConfigurationDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription;
    private final ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription;
    private final RunConfigurationDescription runConfigurationDescription;
    private final FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription;
    private final EnvironmentPropertyDescriptions environmentPropertyDescriptions;
    private final ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription;
    private final ApplicationSystemRollbackConfigurationDescription applicationSystemRollbackConfigurationDescription;
    private final List<VpcConfigurationDescription> vpcConfigurationDescriptions;
    private final ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription;

    private ApplicationConfigurationDescription(BuilderImpl builder) {
        this.sqlApplicationConfigurationDescription = builder.sqlApplicationConfigurationDescription;
        this.applicationCodeConfigurationDescription = builder.applicationCodeConfigurationDescription;
        this.runConfigurationDescription = builder.runConfigurationDescription;
        this.flinkApplicationConfigurationDescription = builder.flinkApplicationConfigurationDescription;
        this.environmentPropertyDescriptions = builder.environmentPropertyDescriptions;
        this.applicationSnapshotConfigurationDescription = builder.applicationSnapshotConfigurationDescription;
        this.applicationSystemRollbackConfigurationDescription = builder.applicationSystemRollbackConfigurationDescription;
        this.vpcConfigurationDescriptions = builder.vpcConfigurationDescriptions;
        this.zeppelinApplicationConfigurationDescription = builder.zeppelinApplicationConfigurationDescription;
    }

    public final SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription() {
        return this.sqlApplicationConfigurationDescription;
    }

    public final ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription() {
        return this.applicationCodeConfigurationDescription;
    }

    public final RunConfigurationDescription runConfigurationDescription() {
        return this.runConfigurationDescription;
    }

    public final FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription() {
        return this.flinkApplicationConfigurationDescription;
    }

    public final EnvironmentPropertyDescriptions environmentPropertyDescriptions() {
        return this.environmentPropertyDescriptions;
    }

    public final ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription() {
        return this.applicationSnapshotConfigurationDescription;
    }

    public final ApplicationSystemRollbackConfigurationDescription applicationSystemRollbackConfigurationDescription() {
        return this.applicationSystemRollbackConfigurationDescription;
    }

    public final boolean hasVpcConfigurationDescriptions() {
        return this.vpcConfigurationDescriptions != null && !(this.vpcConfigurationDescriptions instanceof SdkAutoConstructList);
    }

    public final List<VpcConfigurationDescription> vpcConfigurationDescriptions() {
        return this.vpcConfigurationDescriptions;
    }

    public final ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription() {
        return this.zeppelinApplicationConfigurationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlApplicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCodeConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.runConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.flinkApplicationConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentPropertyDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSnapshotConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSystemRollbackConfigurationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcConfigurationDescriptions() ? this.vpcConfigurationDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zeppelinApplicationConfigurationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationConfigurationDescription)) {
            return false;
        }
        ApplicationConfigurationDescription other = (ApplicationConfigurationDescription)obj;
        return Objects.equals(this.sqlApplicationConfigurationDescription(), other.sqlApplicationConfigurationDescription()) && Objects.equals(this.applicationCodeConfigurationDescription(), other.applicationCodeConfigurationDescription()) && Objects.equals(this.runConfigurationDescription(), other.runConfigurationDescription()) && Objects.equals(this.flinkApplicationConfigurationDescription(), other.flinkApplicationConfigurationDescription()) && Objects.equals(this.environmentPropertyDescriptions(), other.environmentPropertyDescriptions()) && Objects.equals(this.applicationSnapshotConfigurationDescription(), other.applicationSnapshotConfigurationDescription()) && Objects.equals(this.applicationSystemRollbackConfigurationDescription(), other.applicationSystemRollbackConfigurationDescription()) && this.hasVpcConfigurationDescriptions() == other.hasVpcConfigurationDescriptions() && Objects.equals(this.vpcConfigurationDescriptions(), other.vpcConfigurationDescriptions()) && Objects.equals(this.zeppelinApplicationConfigurationDescription(), other.zeppelinApplicationConfigurationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationConfigurationDescription").add("SqlApplicationConfigurationDescription", (Object)this.sqlApplicationConfigurationDescription()).add("ApplicationCodeConfigurationDescription", (Object)this.applicationCodeConfigurationDescription()).add("RunConfigurationDescription", (Object)this.runConfigurationDescription()).add("FlinkApplicationConfigurationDescription", (Object)this.flinkApplicationConfigurationDescription()).add("EnvironmentPropertyDescriptions", (Object)this.environmentPropertyDescriptions()).add("ApplicationSnapshotConfigurationDescription", (Object)this.applicationSnapshotConfigurationDescription()).add("ApplicationSystemRollbackConfigurationDescription", (Object)this.applicationSystemRollbackConfigurationDescription()).add("VpcConfigurationDescriptions", this.hasVpcConfigurationDescriptions() ? this.vpcConfigurationDescriptions() : null).add("ZeppelinApplicationConfigurationDescription", (Object)this.zeppelinApplicationConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SqlApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.sqlApplicationConfigurationDescription()));
            }
            case "ApplicationCodeConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationCodeConfigurationDescription()));
            }
            case "RunConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.runConfigurationDescription()));
            }
            case "FlinkApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.flinkApplicationConfigurationDescription()));
            }
            case "EnvironmentPropertyDescriptions": {
                return Optional.ofNullable(clazz.cast(this.environmentPropertyDescriptions()));
            }
            case "ApplicationSnapshotConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationSnapshotConfigurationDescription()));
            }
            case "ApplicationSystemRollbackConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationSystemRollbackConfigurationDescription()));
            }
            case "VpcConfigurationDescriptions": {
                return Optional.ofNullable(clazz.cast(this.vpcConfigurationDescriptions()));
            }
            case "ZeppelinApplicationConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.zeppelinApplicationConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SqlApplicationConfigurationDescription", SQL_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("ApplicationCodeConfigurationDescription", APPLICATION_CODE_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("RunConfigurationDescription", RUN_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("FlinkApplicationConfigurationDescription", FLINK_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("EnvironmentPropertyDescriptions", ENVIRONMENT_PROPERTY_DESCRIPTIONS_FIELD);
        map.put("ApplicationSnapshotConfigurationDescription", APPLICATION_SNAPSHOT_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("ApplicationSystemRollbackConfigurationDescription", APPLICATION_SYSTEM_ROLLBACK_CONFIGURATION_DESCRIPTION_FIELD);
        map.put("VpcConfigurationDescriptions", VPC_CONFIGURATION_DESCRIPTIONS_FIELD);
        map.put("ZeppelinApplicationConfigurationDescription", ZEPPELIN_APPLICATION_CONFIGURATION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationConfigurationDescription, T> g) {
        return obj -> g.apply((ApplicationConfigurationDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription;
        private ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription;
        private RunConfigurationDescription runConfigurationDescription;
        private FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription;
        private EnvironmentPropertyDescriptions environmentPropertyDescriptions;
        private ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription;
        private ApplicationSystemRollbackConfigurationDescription applicationSystemRollbackConfigurationDescription;
        private List<VpcConfigurationDescription> vpcConfigurationDescriptions = DefaultSdkAutoConstructList.getInstance();
        private ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationConfigurationDescription model) {
            this.sqlApplicationConfigurationDescription(model.sqlApplicationConfigurationDescription);
            this.applicationCodeConfigurationDescription(model.applicationCodeConfigurationDescription);
            this.runConfigurationDescription(model.runConfigurationDescription);
            this.flinkApplicationConfigurationDescription(model.flinkApplicationConfigurationDescription);
            this.environmentPropertyDescriptions(model.environmentPropertyDescriptions);
            this.applicationSnapshotConfigurationDescription(model.applicationSnapshotConfigurationDescription);
            this.applicationSystemRollbackConfigurationDescription(model.applicationSystemRollbackConfigurationDescription);
            this.vpcConfigurationDescriptions(model.vpcConfigurationDescriptions);
            this.zeppelinApplicationConfigurationDescription(model.zeppelinApplicationConfigurationDescription);
        }

        public final SqlApplicationConfigurationDescription.Builder getSqlApplicationConfigurationDescription() {
            return this.sqlApplicationConfigurationDescription != null ? this.sqlApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setSqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription.BuilderImpl sqlApplicationConfigurationDescription) {
            this.sqlApplicationConfigurationDescription = sqlApplicationConfigurationDescription != null ? sqlApplicationConfigurationDescription.build() : null;
        }

        @Override
        public final Builder sqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription sqlApplicationConfigurationDescription) {
            this.sqlApplicationConfigurationDescription = sqlApplicationConfigurationDescription;
            return this;
        }

        public final ApplicationCodeConfigurationDescription.Builder getApplicationCodeConfigurationDescription() {
            return this.applicationCodeConfigurationDescription != null ? this.applicationCodeConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription.BuilderImpl applicationCodeConfigurationDescription) {
            this.applicationCodeConfigurationDescription = applicationCodeConfigurationDescription != null ? applicationCodeConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription applicationCodeConfigurationDescription) {
            this.applicationCodeConfigurationDescription = applicationCodeConfigurationDescription;
            return this;
        }

        public final RunConfigurationDescription.Builder getRunConfigurationDescription() {
            return this.runConfigurationDescription != null ? this.runConfigurationDescription.toBuilder() : null;
        }

        public final void setRunConfigurationDescription(RunConfigurationDescription.BuilderImpl runConfigurationDescription) {
            this.runConfigurationDescription = runConfigurationDescription != null ? runConfigurationDescription.build() : null;
        }

        @Override
        public final Builder runConfigurationDescription(RunConfigurationDescription runConfigurationDescription) {
            this.runConfigurationDescription = runConfigurationDescription;
            return this;
        }

        public final FlinkApplicationConfigurationDescription.Builder getFlinkApplicationConfigurationDescription() {
            return this.flinkApplicationConfigurationDescription != null ? this.flinkApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setFlinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription.BuilderImpl flinkApplicationConfigurationDescription) {
            this.flinkApplicationConfigurationDescription = flinkApplicationConfigurationDescription != null ? flinkApplicationConfigurationDescription.build() : null;
        }

        @Override
        public final Builder flinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription flinkApplicationConfigurationDescription) {
            this.flinkApplicationConfigurationDescription = flinkApplicationConfigurationDescription;
            return this;
        }

        public final EnvironmentPropertyDescriptions.Builder getEnvironmentPropertyDescriptions() {
            return this.environmentPropertyDescriptions != null ? this.environmentPropertyDescriptions.toBuilder() : null;
        }

        public final void setEnvironmentPropertyDescriptions(EnvironmentPropertyDescriptions.BuilderImpl environmentPropertyDescriptions) {
            this.environmentPropertyDescriptions = environmentPropertyDescriptions != null ? environmentPropertyDescriptions.build() : null;
        }

        @Override
        public final Builder environmentPropertyDescriptions(EnvironmentPropertyDescriptions environmentPropertyDescriptions) {
            this.environmentPropertyDescriptions = environmentPropertyDescriptions;
            return this;
        }

        public final ApplicationSnapshotConfigurationDescription.Builder getApplicationSnapshotConfigurationDescription() {
            return this.applicationSnapshotConfigurationDescription != null ? this.applicationSnapshotConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription.BuilderImpl applicationSnapshotConfigurationDescription) {
            this.applicationSnapshotConfigurationDescription = applicationSnapshotConfigurationDescription != null ? applicationSnapshotConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription applicationSnapshotConfigurationDescription) {
            this.applicationSnapshotConfigurationDescription = applicationSnapshotConfigurationDescription;
            return this;
        }

        public final ApplicationSystemRollbackConfigurationDescription.Builder getApplicationSystemRollbackConfigurationDescription() {
            return this.applicationSystemRollbackConfigurationDescription != null ? this.applicationSystemRollbackConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationSystemRollbackConfigurationDescription(ApplicationSystemRollbackConfigurationDescription.BuilderImpl applicationSystemRollbackConfigurationDescription) {
            this.applicationSystemRollbackConfigurationDescription = applicationSystemRollbackConfigurationDescription != null ? applicationSystemRollbackConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationSystemRollbackConfigurationDescription(ApplicationSystemRollbackConfigurationDescription applicationSystemRollbackConfigurationDescription) {
            this.applicationSystemRollbackConfigurationDescription = applicationSystemRollbackConfigurationDescription;
            return this;
        }

        public final List<VpcConfigurationDescription.Builder> getVpcConfigurationDescriptions() {
            List<VpcConfigurationDescription.Builder> result = VpcConfigurationDescriptionsCopier.copyToBuilder(this.vpcConfigurationDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcConfigurationDescriptions(Collection<VpcConfigurationDescription.BuilderImpl> vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions = VpcConfigurationDescriptionsCopier.copyFromBuilder(vpcConfigurationDescriptions);
        }

        @Override
        public final Builder vpcConfigurationDescriptions(Collection<VpcConfigurationDescription> vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions = VpcConfigurationDescriptionsCopier.copy(vpcConfigurationDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationDescriptions(VpcConfigurationDescription ... vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions(Arrays.asList(vpcConfigurationDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcConfigurationDescriptions(Consumer<VpcConfigurationDescription.Builder> ... vpcConfigurationDescriptions) {
            this.vpcConfigurationDescriptions(Stream.of(vpcConfigurationDescriptions).map(c -> (VpcConfigurationDescription)((VpcConfigurationDescription.Builder)VpcConfigurationDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ZeppelinApplicationConfigurationDescription.Builder getZeppelinApplicationConfigurationDescription() {
            return this.zeppelinApplicationConfigurationDescription != null ? this.zeppelinApplicationConfigurationDescription.toBuilder() : null;
        }

        public final void setZeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription.BuilderImpl zeppelinApplicationConfigurationDescription) {
            this.zeppelinApplicationConfigurationDescription = zeppelinApplicationConfigurationDescription != null ? zeppelinApplicationConfigurationDescription.build() : null;
        }

        @Override
        public final Builder zeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription zeppelinApplicationConfigurationDescription) {
            this.zeppelinApplicationConfigurationDescription = zeppelinApplicationConfigurationDescription;
            return this;
        }

        public ApplicationConfigurationDescription build() {
            return new ApplicationConfigurationDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationConfigurationDescription> {
        public Builder sqlApplicationConfigurationDescription(SqlApplicationConfigurationDescription var1);

        default public Builder sqlApplicationConfigurationDescription(Consumer<SqlApplicationConfigurationDescription.Builder> sqlApplicationConfigurationDescription) {
            return this.sqlApplicationConfigurationDescription((SqlApplicationConfigurationDescription)((SqlApplicationConfigurationDescription.Builder)SqlApplicationConfigurationDescription.builder().applyMutation(sqlApplicationConfigurationDescription)).build());
        }

        public Builder applicationCodeConfigurationDescription(ApplicationCodeConfigurationDescription var1);

        default public Builder applicationCodeConfigurationDescription(Consumer<ApplicationCodeConfigurationDescription.Builder> applicationCodeConfigurationDescription) {
            return this.applicationCodeConfigurationDescription((ApplicationCodeConfigurationDescription)((ApplicationCodeConfigurationDescription.Builder)ApplicationCodeConfigurationDescription.builder().applyMutation(applicationCodeConfigurationDescription)).build());
        }

        public Builder runConfigurationDescription(RunConfigurationDescription var1);

        default public Builder runConfigurationDescription(Consumer<RunConfigurationDescription.Builder> runConfigurationDescription) {
            return this.runConfigurationDescription((RunConfigurationDescription)((RunConfigurationDescription.Builder)RunConfigurationDescription.builder().applyMutation(runConfigurationDescription)).build());
        }

        public Builder flinkApplicationConfigurationDescription(FlinkApplicationConfigurationDescription var1);

        default public Builder flinkApplicationConfigurationDescription(Consumer<FlinkApplicationConfigurationDescription.Builder> flinkApplicationConfigurationDescription) {
            return this.flinkApplicationConfigurationDescription((FlinkApplicationConfigurationDescription)((FlinkApplicationConfigurationDescription.Builder)FlinkApplicationConfigurationDescription.builder().applyMutation(flinkApplicationConfigurationDescription)).build());
        }

        public Builder environmentPropertyDescriptions(EnvironmentPropertyDescriptions var1);

        default public Builder environmentPropertyDescriptions(Consumer<EnvironmentPropertyDescriptions.Builder> environmentPropertyDescriptions) {
            return this.environmentPropertyDescriptions((EnvironmentPropertyDescriptions)((EnvironmentPropertyDescriptions.Builder)EnvironmentPropertyDescriptions.builder().applyMutation(environmentPropertyDescriptions)).build());
        }

        public Builder applicationSnapshotConfigurationDescription(ApplicationSnapshotConfigurationDescription var1);

        default public Builder applicationSnapshotConfigurationDescription(Consumer<ApplicationSnapshotConfigurationDescription.Builder> applicationSnapshotConfigurationDescription) {
            return this.applicationSnapshotConfigurationDescription((ApplicationSnapshotConfigurationDescription)((ApplicationSnapshotConfigurationDescription.Builder)ApplicationSnapshotConfigurationDescription.builder().applyMutation(applicationSnapshotConfigurationDescription)).build());
        }

        public Builder applicationSystemRollbackConfigurationDescription(ApplicationSystemRollbackConfigurationDescription var1);

        default public Builder applicationSystemRollbackConfigurationDescription(Consumer<ApplicationSystemRollbackConfigurationDescription.Builder> applicationSystemRollbackConfigurationDescription) {
            return this.applicationSystemRollbackConfigurationDescription((ApplicationSystemRollbackConfigurationDescription)((ApplicationSystemRollbackConfigurationDescription.Builder)ApplicationSystemRollbackConfigurationDescription.builder().applyMutation(applicationSystemRollbackConfigurationDescription)).build());
        }

        public Builder vpcConfigurationDescriptions(Collection<VpcConfigurationDescription> var1);

        public Builder vpcConfigurationDescriptions(VpcConfigurationDescription ... var1);

        public Builder vpcConfigurationDescriptions(Consumer<VpcConfigurationDescription.Builder> ... var1);

        public Builder zeppelinApplicationConfigurationDescription(ZeppelinApplicationConfigurationDescription var1);

        default public Builder zeppelinApplicationConfigurationDescription(Consumer<ZeppelinApplicationConfigurationDescription.Builder> zeppelinApplicationConfigurationDescription) {
            return this.zeppelinApplicationConfigurationDescription((ZeppelinApplicationConfigurationDescription)((ZeppelinApplicationConfigurationDescription.Builder)ZeppelinApplicationConfigurationDescription.builder().applyMutation(zeppelinApplicationConfigurationDescription)).build());
        }
    }
}

