/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.APIName;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataEndpointRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, GetDataEndpointRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetDataEndpointRequest.getter(GetDataEndpointRequest::streamName)).setter(GetDataEndpointRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetDataEndpointRequest.getter(GetDataEndpointRequest::streamARN)).setter(GetDataEndpointRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> API_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("APIName").getter(GetDataEndpointRequest.getter(GetDataEndpointRequest::apiNameAsString)).setter(GetDataEndpointRequest.setter(Builder::apiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APIName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, API_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDataEndpointRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String streamARN;
    private final String apiName;

    private GetDataEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.apiName = builder.apiName;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final APIName apiName() {
        return APIName.fromValue(this.apiName);
    }

    public final String apiNameAsString() {
        return this.apiName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataEndpointRequest)) {
            return false;
        }
        GetDataEndpointRequest other = (GetDataEndpointRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.apiNameAsString(), other.apiNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataEndpointRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("APIName", (Object)this.apiNameAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "APIName": {
                return Optional.ofNullable(clazz.cast(this.apiNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("APIName", API_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataEndpointRequest, T> g) {
        return obj -> g.apply((GetDataEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String apiName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataEndpointRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.apiName(model.apiName);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getApiName() {
            return this.apiName;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        @Override
        public final Builder apiName(APIName apiName) {
            this.apiName(apiName == null ? null : apiName.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDataEndpointRequest build() {
            return new GetDataEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataEndpointRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder apiName(String var1);

        public Builder apiName(APIName var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

