/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.UploaderStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LastUploaderStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LastUploaderStatus> {
    private static final SdkField<String> JOB_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatusDetails").getter(LastUploaderStatus.getter(LastUploaderStatus::jobStatusDetails)).setter(LastUploaderStatus.setter(Builder::jobStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatusDetails").build()}).build();
    private static final SdkField<Instant> LAST_COLLECTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCollectedTime").getter(LastUploaderStatus.getter(LastUploaderStatus::lastCollectedTime)).setter(LastUploaderStatus.setter(Builder::lastCollectedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCollectedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(LastUploaderStatus.getter(LastUploaderStatus::lastUpdatedTime)).setter(LastUploaderStatus.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> UPLOADER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UploaderStatus").getter(LastUploaderStatus.getter(LastUploaderStatus::uploaderStatusAsString)).setter(LastUploaderStatus.setter(Builder::uploaderStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploaderStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_DETAILS_FIELD, LAST_COLLECTED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, UPLOADER_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LastUploaderStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String jobStatusDetails;
    private final Instant lastCollectedTime;
    private final Instant lastUpdatedTime;
    private final String uploaderStatus;

    private LastUploaderStatus(BuilderImpl builder) {
        this.jobStatusDetails = builder.jobStatusDetails;
        this.lastCollectedTime = builder.lastCollectedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.uploaderStatus = builder.uploaderStatus;
    }

    public final String jobStatusDetails() {
        return this.jobStatusDetails;
    }

    public final Instant lastCollectedTime() {
        return this.lastCollectedTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final UploaderStatus uploaderStatus() {
        return UploaderStatus.fromValue(this.uploaderStatus);
    }

    public final String uploaderStatusAsString() {
        return this.uploaderStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCollectedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploaderStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUploaderStatus)) {
            return false;
        }
        LastUploaderStatus other = (LastUploaderStatus)obj;
        return Objects.equals(this.jobStatusDetails(), other.jobStatusDetails()) && Objects.equals(this.lastCollectedTime(), other.lastCollectedTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.uploaderStatusAsString(), other.uploaderStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LastUploaderStatus").add("JobStatusDetails", (Object)this.jobStatusDetails()).add("LastCollectedTime", (Object)this.lastCollectedTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("UploaderStatus", (Object)this.uploaderStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.jobStatusDetails()));
            }
            case "LastCollectedTime": {
                return Optional.ofNullable(clazz.cast(this.lastCollectedTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "UploaderStatus": {
                return Optional.ofNullable(clazz.cast(this.uploaderStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobStatusDetails", JOB_STATUS_DETAILS_FIELD);
        map.put("LastCollectedTime", LAST_COLLECTED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("UploaderStatus", UPLOADER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastUploaderStatus, T> g) {
        return obj -> g.apply((LastUploaderStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobStatusDetails;
        private Instant lastCollectedTime;
        private Instant lastUpdatedTime;
        private String uploaderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUploaderStatus model) {
            this.jobStatusDetails(model.jobStatusDetails);
            this.lastCollectedTime(model.lastCollectedTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.uploaderStatus(model.uploaderStatus);
        }

        public final String getJobStatusDetails() {
            return this.jobStatusDetails;
        }

        public final void setJobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
        }

        @Override
        public final Builder jobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
            return this;
        }

        public final Instant getLastCollectedTime() {
            return this.lastCollectedTime;
        }

        public final void setLastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
        }

        @Override
        public final Builder lastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getUploaderStatus() {
            return this.uploaderStatus;
        }

        public final void setUploaderStatus(String uploaderStatus) {
            this.uploaderStatus = uploaderStatus;
        }

        @Override
        public final Builder uploaderStatus(String uploaderStatus) {
            this.uploaderStatus = uploaderStatus;
            return this;
        }

        @Override
        public final Builder uploaderStatus(UploaderStatus uploaderStatus) {
            this.uploaderStatus(uploaderStatus == null ? null : uploaderStatus.toString());
            return this;
        }

        public LastUploaderStatus build() {
            return new LastUploaderStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LastUploaderStatus> {
        public Builder jobStatusDetails(String var1);

        public Builder lastCollectedTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder uploaderStatus(String var1);

        public Builder uploaderStatus(UploaderStatus var1);
    }
}

