/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEdgeAgentConfigurationsResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, ListEdgeAgentConfigurationsResponse> {
    private static final SdkField<List<ListEdgeAgentConfigurationsEdgeConfig>> EDGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeConfigs").getter(ListEdgeAgentConfigurationsResponse.getter(ListEdgeAgentConfigurationsResponse::edgeConfigs)).setter(ListEdgeAgentConfigurationsResponse.setter(Builder::edgeConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListEdgeAgentConfigurationsEdgeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEdgeAgentConfigurationsResponse.getter(ListEdgeAgentConfigurationsResponse::nextToken)).setter(ListEdgeAgentConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEdgeAgentConfigurationsResponse.memberNameToFieldInitializer();
    private final List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs;
    private final String nextToken;

    private ListEdgeAgentConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.edgeConfigs = builder.edgeConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEdgeConfigs() {
        return this.edgeConfigs != null && !(this.edgeConfigs instanceof SdkAutoConstructList);
    }

    public final List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs() {
        return this.edgeConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeConfigs() ? this.edgeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgeAgentConfigurationsResponse)) {
            return false;
        }
        ListEdgeAgentConfigurationsResponse other = (ListEdgeAgentConfigurationsResponse)((Object)obj);
        return this.hasEdgeConfigs() == other.hasEdgeConfigs() && Objects.equals(this.edgeConfigs(), other.edgeConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEdgeAgentConfigurationsResponse").add("EdgeConfigs", this.hasEdgeConfigs() ? this.edgeConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EdgeConfigs": {
                return Optional.ofNullable(clazz.cast(this.edgeConfigs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EdgeConfigs", EDGE_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEdgeAgentConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEdgeAgentConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgeAgentConfigurationsResponse model) {
            super(model);
            this.edgeConfigs(model.edgeConfigs);
            this.nextToken(model.nextToken);
        }

        public final List<ListEdgeAgentConfigurationsEdgeConfig.Builder> getEdgeConfigs() {
            List<ListEdgeAgentConfigurationsEdgeConfig.Builder> result = ListEdgeAgentConfigurationsEdgeConfigListCopier.copyToBuilder(this.edgeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig.BuilderImpl> edgeConfigs) {
            this.edgeConfigs = ListEdgeAgentConfigurationsEdgeConfigListCopier.copyFromBuilder(edgeConfigs);
        }

        @Override
        public final Builder edgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs) {
            this.edgeConfigs = ListEdgeAgentConfigurationsEdgeConfigListCopier.copy(edgeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeConfigs(ListEdgeAgentConfigurationsEdgeConfig ... edgeConfigs) {
            this.edgeConfigs(Arrays.asList(edgeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeConfigs(Consumer<ListEdgeAgentConfigurationsEdgeConfig.Builder> ... edgeConfigs) {
            this.edgeConfigs(Stream.of(edgeConfigs).map(c -> (ListEdgeAgentConfigurationsEdgeConfig)((ListEdgeAgentConfigurationsEdgeConfig.Builder)ListEdgeAgentConfigurationsEdgeConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEdgeAgentConfigurationsResponse build() {
            return new ListEdgeAgentConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEdgeAgentConfigurationsResponse> {
        public Builder edgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig> var1);

        public Builder edgeConfigs(ListEdgeAgentConfigurationsEdgeConfig ... var1);

        public Builder edgeConfigs(Consumer<ListEdgeAgentConfigurationsEdgeConfig.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

