/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kms.model.KeyEncryptionMechanism;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecipientInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecipientInfo> {
    private static final SdkField<String> KEY_ENCRYPTION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyEncryptionAlgorithm").getter(RecipientInfo.getter(RecipientInfo::keyEncryptionAlgorithmAsString)).setter(RecipientInfo.setter(Builder::keyEncryptionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyEncryptionAlgorithm").build()}).build();
    private static final SdkField<SdkBytes> ATTESTATION_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("AttestationDocument").getter(RecipientInfo.getter(RecipientInfo::attestationDocument)).setter(RecipientInfo.setter(Builder::attestationDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttestationDocument").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ENCRYPTION_ALGORITHM_FIELD, ATTESTATION_DOCUMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecipientInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyEncryptionAlgorithm;
    private final SdkBytes attestationDocument;

    private RecipientInfo(BuilderImpl builder) {
        this.keyEncryptionAlgorithm = builder.keyEncryptionAlgorithm;
        this.attestationDocument = builder.attestationDocument;
    }

    public final KeyEncryptionMechanism keyEncryptionAlgorithm() {
        return KeyEncryptionMechanism.fromValue(this.keyEncryptionAlgorithm);
    }

    public final String keyEncryptionAlgorithmAsString() {
        return this.keyEncryptionAlgorithm;
    }

    public final SdkBytes attestationDocument() {
        return this.attestationDocument;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyEncryptionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attestationDocument());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecipientInfo)) {
            return false;
        }
        RecipientInfo other = (RecipientInfo)obj;
        return Objects.equals(this.keyEncryptionAlgorithmAsString(), other.keyEncryptionAlgorithmAsString()) && Objects.equals(this.attestationDocument(), other.attestationDocument());
    }

    public final String toString() {
        return ToString.builder((String)"RecipientInfo").add("KeyEncryptionAlgorithm", (Object)this.keyEncryptionAlgorithmAsString()).add("AttestationDocument", (Object)this.attestationDocument()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyEncryptionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.keyEncryptionAlgorithmAsString()));
            }
            case "AttestationDocument": {
                return Optional.ofNullable(clazz.cast(this.attestationDocument()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyEncryptionAlgorithm", KEY_ENCRYPTION_ALGORITHM_FIELD);
        map.put("AttestationDocument", ATTESTATION_DOCUMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecipientInfo, T> g) {
        return obj -> g.apply((RecipientInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyEncryptionAlgorithm;
        private SdkBytes attestationDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(RecipientInfo model) {
            this.keyEncryptionAlgorithm(model.keyEncryptionAlgorithm);
            this.attestationDocument(model.attestationDocument);
        }

        public final String getKeyEncryptionAlgorithm() {
            return this.keyEncryptionAlgorithm;
        }

        public final void setKeyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
            this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        }

        @Override
        public final Builder keyEncryptionAlgorithm(String keyEncryptionAlgorithm) {
            this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
            return this;
        }

        @Override
        public final Builder keyEncryptionAlgorithm(KeyEncryptionMechanism keyEncryptionAlgorithm) {
            this.keyEncryptionAlgorithm(keyEncryptionAlgorithm == null ? null : keyEncryptionAlgorithm.toString());
            return this;
        }

        public final ByteBuffer getAttestationDocument() {
            return this.attestationDocument == null ? null : this.attestationDocument.asByteBuffer();
        }

        public final void setAttestationDocument(ByteBuffer attestationDocument) {
            this.attestationDocument(attestationDocument == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)attestationDocument));
        }

        @Override
        public final Builder attestationDocument(SdkBytes attestationDocument) {
            this.attestationDocument = attestationDocument;
            return this;
        }

        public RecipientInfo build() {
            return new RecipientInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecipientInfo> {
        public Builder keyEncryptionAlgorithm(String var1);

        public Builder keyEncryptionAlgorithm(KeyEncryptionMechanism var1);

        public Builder attestationDocument(SdkBytes var1);
    }
}

