/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelbuilding.model.ListOfUtteranceCopier;
import software.amazon.awssdk.services.lexmodelbuilding.model.UtteranceData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UtteranceList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UtteranceList> {
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(UtteranceList.getter(UtteranceList::botVersion)).setter(UtteranceList.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<List<UtteranceData>> UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utterances").getter(UtteranceList.getter(UtteranceList::utterances)).setter(UtteranceList.setter(Builder::utterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtteranceData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_VERSION_FIELD, UTTERANCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String botVersion;
    private final List<UtteranceData> utterances;

    private UtteranceList(BuilderImpl builder) {
        this.botVersion = builder.botVersion;
        this.utterances = builder.utterances;
    }

    public String botVersion() {
        return this.botVersion;
    }

    public boolean hasUtterances() {
        return this.utterances != null && !(this.utterances instanceof SdkAutoConstructList);
    }

    public List<UtteranceData> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtterances() ? this.utterances() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceList)) {
            return false;
        }
        UtteranceList other = (UtteranceList)obj;
        return Objects.equals(this.botVersion(), other.botVersion()) && this.hasUtterances() == other.hasUtterances() && Objects.equals(this.utterances(), other.utterances());
    }

    public String toString() {
        return ToString.builder((String)"UtteranceList").add("BotVersion", (Object)this.botVersion()).add("Utterances", this.hasUtterances() ? this.utterances() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "utterances": {
                return Optional.ofNullable(clazz.cast(this.utterances()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtteranceList, T> g) {
        return obj -> g.apply((UtteranceList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String botVersion;
        private List<UtteranceData> utterances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceList model) {
            this.botVersion(model.botVersion);
            this.utterances(model.utterances);
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        public final Collection<UtteranceData.Builder> getUtterances() {
            if (this.utterances instanceof SdkAutoConstructList) {
                return null;
            }
            return this.utterances != null ? (Collection)this.utterances.stream().map(UtteranceData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder utterances(Collection<UtteranceData> utterances) {
            this.utterances = ListOfUtteranceCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceData ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(Consumer<UtteranceData.Builder> ... utterances) {
            this.utterances(Stream.of(utterances).map(c -> (UtteranceData)((UtteranceData.Builder)UtteranceData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtterances(Collection<UtteranceData.BuilderImpl> utterances) {
            this.utterances = ListOfUtteranceCopier.copyFromBuilder(utterances);
        }

        public UtteranceList build() {
            return new UtteranceList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UtteranceList> {
        public Builder botVersion(String var1);

        public Builder utterances(Collection<UtteranceData> var1);

        public Builder utterances(UtteranceData ... var1);

        public Builder utterances(Consumer<UtteranceData.Builder> ... var1);
    }
}

