/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelbuilding.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelbuilding.LexModelBuildingClient;
import software.amazon.awssdk.services.lexmodelbuilding.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsRequest;
import software.amazon.awssdk.services.lexmodelbuilding.model.GetBuiltinIntentsResponse;

public class GetBuiltinIntentsIterable
implements SdkIterable<GetBuiltinIntentsResponse> {
    private final LexModelBuildingClient client;
    private final GetBuiltinIntentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetBuiltinIntentsIterable(LexModelBuildingClient client, GetBuiltinIntentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetBuiltinIntentsResponseFetcher();
    }

    public Iterator<GetBuiltinIntentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetBuiltinIntentsResponseFetcher
    implements SyncPageFetcher<GetBuiltinIntentsResponse> {
        private GetBuiltinIntentsResponseFetcher() {
        }

        public boolean hasNextPage(GetBuiltinIntentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetBuiltinIntentsResponse nextPage(GetBuiltinIntentsResponse previousPage) {
            if (previousPage == null) {
                return GetBuiltinIntentsIterable.this.client.getBuiltinIntents(GetBuiltinIntentsIterable.this.firstRequest);
            }
            return GetBuiltinIntentsIterable.this.client.getBuiltinIntents((GetBuiltinIntentsRequest)((Object)GetBuiltinIntentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

