/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntimev2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexruntimev2.model.DialogActionType;
import software.amazon.awssdk.services.lexruntimev2.model.ElicitSubSlot;
import software.amazon.awssdk.services.lexruntimev2.model.StyleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DialogAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DialogAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DialogAction.getter(DialogAction::typeAsString)).setter(DialogAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotToElicit").getter(DialogAction.getter(DialogAction::slotToElicit)).setter(DialogAction.setter(Builder::slotToElicit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()}).build();
    private static final SdkField<String> SLOT_ELICITATION_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotElicitationStyle").getter(DialogAction.getter(DialogAction::slotElicitationStyleAsString)).setter(DialogAction.setter(Builder::slotElicitationStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotElicitationStyle").build()}).build();
    private static final SdkField<ElicitSubSlot> SUB_SLOT_TO_ELICIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("subSlotToElicit").getter(DialogAction.getter(DialogAction::subSlotToElicit)).setter(DialogAction.setter(Builder::subSlotToElicit)).constructor(ElicitSubSlot::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subSlotToElicit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SLOT_TO_ELICIT_FIELD, SLOT_ELICITATION_STYLE_FIELD, SUB_SLOT_TO_ELICIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DialogAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String slotToElicit;
    private final String slotElicitationStyle;
    private final ElicitSubSlot subSlotToElicit;

    private DialogAction(BuilderImpl builder) {
        this.type = builder.type;
        this.slotToElicit = builder.slotToElicit;
        this.slotElicitationStyle = builder.slotElicitationStyle;
        this.subSlotToElicit = builder.subSlotToElicit;
    }

    public final DialogActionType type() {
        return DialogActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String slotToElicit() {
        return this.slotToElicit;
    }

    public final StyleType slotElicitationStyle() {
        return StyleType.fromValue(this.slotElicitationStyle);
    }

    public final String slotElicitationStyleAsString() {
        return this.slotElicitationStyle;
    }

    public final ElicitSubSlot subSlotToElicit() {
        return this.subSlotToElicit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotElicitationStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subSlotToElicit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.slotToElicit(), other.slotToElicit()) && Objects.equals(this.slotElicitationStyleAsString(), other.slotElicitationStyleAsString()) && Objects.equals(this.subSlotToElicit(), other.subSlotToElicit());
    }

    public final String toString() {
        return ToString.builder((String)"DialogAction").add("Type", (Object)this.typeAsString()).add("SlotToElicit", (Object)this.slotToElicit()).add("SlotElicitationStyle", (Object)this.slotElicitationStyleAsString()).add("SubSlotToElicit", (Object)this.subSlotToElicit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "slotToElicit": {
                return Optional.ofNullable(clazz.cast(this.slotToElicit()));
            }
            case "slotElicitationStyle": {
                return Optional.ofNullable(clazz.cast(this.slotElicitationStyleAsString()));
            }
            case "subSlotToElicit": {
                return Optional.ofNullable(clazz.cast(this.subSlotToElicit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("slotToElicit", SLOT_TO_ELICIT_FIELD);
        map.put("slotElicitationStyle", SLOT_ELICITATION_STYLE_FIELD);
        map.put("subSlotToElicit", SUB_SLOT_TO_ELICIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DialogAction, T> g) {
        return obj -> g.apply((DialogAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String slotToElicit;
        private String slotElicitationStyle;
        private ElicitSubSlot subSlotToElicit;

        private BuilderImpl() {
        }

        private BuilderImpl(DialogAction model) {
            this.type(model.type);
            this.slotToElicit(model.slotToElicit);
            this.slotElicitationStyle(model.slotElicitationStyle);
            this.subSlotToElicit(model.subSlotToElicit);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DialogActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSlotToElicit() {
            return this.slotToElicit;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final String getSlotElicitationStyle() {
            return this.slotElicitationStyle;
        }

        public final void setSlotElicitationStyle(String slotElicitationStyle) {
            this.slotElicitationStyle = slotElicitationStyle;
        }

        @Override
        public final Builder slotElicitationStyle(String slotElicitationStyle) {
            this.slotElicitationStyle = slotElicitationStyle;
            return this;
        }

        @Override
        public final Builder slotElicitationStyle(StyleType slotElicitationStyle) {
            this.slotElicitationStyle(slotElicitationStyle == null ? null : slotElicitationStyle.toString());
            return this;
        }

        public final ElicitSubSlot.Builder getSubSlotToElicit() {
            return this.subSlotToElicit != null ? this.subSlotToElicit.toBuilder() : null;
        }

        public final void setSubSlotToElicit(ElicitSubSlot.BuilderImpl subSlotToElicit) {
            this.subSlotToElicit = subSlotToElicit != null ? subSlotToElicit.build() : null;
        }

        @Override
        public final Builder subSlotToElicit(ElicitSubSlot subSlotToElicit) {
            this.subSlotToElicit = subSlotToElicit;
            return this;
        }

        public DialogAction build() {
            return new DialogAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DialogAction> {
        public Builder type(String var1);

        public Builder type(DialogActionType var1);

        public Builder slotToElicit(String var1);

        public Builder slotElicitationStyle(String var1);

        public Builder slotElicitationStyle(StyleType var1);

        public Builder subSlotToElicit(ElicitSubSlot var1);

        default public Builder subSlotToElicit(Consumer<ElicitSubSlot.Builder> subSlotToElicit) {
            return this.subSlotToElicit((ElicitSubSlot)((ElicitSubSlot.Builder)ElicitSubSlot.builder().applyMutation(subSlotToElicit)).build());
        }
    }
}

