/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.licensemanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.licensemanager.model.ProductInformationFilter;
import software.amazon.awssdk.services.licensemanager.model.ProductInformationFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProductInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProductInformation> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProductInformation.getter(ProductInformation::resourceType)).setter(ProductInformation.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<ProductInformationFilter>> PRODUCT_INFORMATION_FILTER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ProductInformation.getter(ProductInformation::productInformationFilterList)).setter(ProductInformation.setter(Builder::productInformationFilterList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductInformationFilterList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductInformationFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, PRODUCT_INFORMATION_FILTER_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final List<ProductInformationFilter> productInformationFilterList;

    private ProductInformation(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.productInformationFilterList = builder.productInformationFilterList;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public boolean hasProductInformationFilterList() {
        return this.productInformationFilterList != null && !(this.productInformationFilterList instanceof SdkAutoConstructList);
    }

    public List<ProductInformationFilter> productInformationFilterList() {
        return this.productInformationFilterList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.productInformationFilterList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductInformation)) {
            return false;
        }
        ProductInformation other = (ProductInformation)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.productInformationFilterList(), other.productInformationFilterList());
    }

    public String toString() {
        return ToString.builder((String)"ProductInformation").add("ResourceType", (Object)this.resourceType()).add("ProductInformationFilterList", this.productInformationFilterList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ProductInformationFilterList": {
                return Optional.ofNullable(clazz.cast(this.productInformationFilterList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductInformation, T> g) {
        return obj -> g.apply((ProductInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private List<ProductInformationFilter> productInformationFilterList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProductInformation model) {
            this.resourceType(model.resourceType);
            this.productInformationFilterList(model.productInformationFilterList);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<ProductInformationFilter.Builder> getProductInformationFilterList() {
            return this.productInformationFilterList != null ? (Collection)this.productInformationFilterList.stream().map(ProductInformationFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productInformationFilterList(Collection<ProductInformationFilter> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copy(productInformationFilterList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterList(ProductInformationFilter ... productInformationFilterList) {
            this.productInformationFilterList(Arrays.asList(productInformationFilterList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productInformationFilterList(Consumer<ProductInformationFilter.Builder> ... productInformationFilterList) {
            this.productInformationFilterList(Stream.of(productInformationFilterList).map(c -> (ProductInformationFilter)((ProductInformationFilter.Builder)ProductInformationFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProductInformationFilterList(Collection<ProductInformationFilter.BuilderImpl> productInformationFilterList) {
            this.productInformationFilterList = ProductInformationFilterListCopier.copyFromBuilder(productInformationFilterList);
        }

        public ProductInformation build() {
            return new ProductInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProductInformation> {
        public Builder resourceType(String var1);

        public Builder productInformationFilterList(Collection<ProductInformationFilter> var1);

        public Builder productInformationFilterList(ProductInformationFilter ... var1);

        public Builder productInformationFilterList(Consumer<ProductInformationFilter.Builder> ... var1);
    }
}

