/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlueprintsResponse extends LightsailResponse implements
        ToCopyableBuilder<GetBlueprintsResponse.Builder, GetBlueprintsResponse> {
    private static final SdkField<List<Blueprint>> BLUEPRINTS_FIELD = SdkField
            .<List<Blueprint>> builder(MarshallingType.LIST)
            .getter(getter(GetBlueprintsResponse::blueprints))
            .setter(setter(Builder::blueprints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Blueprint> builder(MarshallingType.SDK_POJO)
                                            .constructor(Blueprint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetBlueprintsResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUEPRINTS_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<Blueprint> blueprints;

    private final String nextPageToken;

    private GetBlueprintsResponse(BuilderImpl builder) {
        super(builder);
        this.blueprints = builder.blueprints;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the Blueprints property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasBlueprints() {
        return blueprints != null && !(blueprints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that contains information about the available blueprints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlueprints()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of key-value pairs that contains information about the available blueprints.
     */
    public List<Blueprint> blueprints() {
        return blueprints;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get blueprints request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get blueprints request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(blueprints());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlueprintsResponse)) {
            return false;
        }
        GetBlueprintsResponse other = (GetBlueprintsResponse) obj;
        return Objects.equals(blueprints(), other.blueprints()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBlueprintsResponse").add("Blueprints", blueprints()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "blueprints":
            return Optional.ofNullable(clazz.cast(blueprints()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlueprintsResponse, T> g) {
        return obj -> g.apply((GetBlueprintsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBlueprintsResponse> {
        /**
         * <p>
         * An array of key-value pairs that contains information about the available blueprints.
         * </p>
         * 
         * @param blueprints
         *        An array of key-value pairs that contains information about the available blueprints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Collection<Blueprint> blueprints);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available blueprints.
         * </p>
         * 
         * @param blueprints
         *        An array of key-value pairs that contains information about the available blueprints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueprints(Blueprint... blueprints);

        /**
         * <p>
         * An array of key-value pairs that contains information about the available blueprints.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Blueprint>.Builder} avoiding the need to
         * create one manually via {@link List<Blueprint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Blueprint>.Builder#build()} is called immediately and its
         * result is passed to {@link #blueprints(List<Blueprint>)}.
         * 
         * @param blueprints
         *        a consumer that will call methods on {@link List<Blueprint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueprints(List<Blueprint>)
         */
        Builder blueprints(Consumer<Blueprint.Builder>... blueprints);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get blueprints request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get blueprints request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<Blueprint> blueprints = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlueprintsResponse model) {
            super(model);
            blueprints(model.blueprints);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<Blueprint.Builder> getBlueprints() {
            return blueprints != null ? blueprints.stream().map(Blueprint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blueprints(Collection<Blueprint> blueprints) {
            this.blueprints = BlueprintListCopier.copy(blueprints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Blueprint... blueprints) {
            blueprints(Arrays.asList(blueprints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blueprints(Consumer<Blueprint.Builder>... blueprints) {
            blueprints(Stream.of(blueprints).map(c -> Blueprint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlueprints(Collection<Blueprint.BuilderImpl> blueprints) {
            this.blueprints = BlueprintListCopier.copyFromBuilder(blueprints);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetBlueprintsResponse build() {
            return new GetBlueprintsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
