/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRelationalDatabasesResponse extends LightsailResponse implements
        ToCopyableBuilder<GetRelationalDatabasesResponse.Builder, GetRelationalDatabasesResponse> {
    private static final SdkField<List<RelationalDatabase>> RELATIONAL_DATABASES_FIELD = SdkField
            .<List<RelationalDatabase>> builder(MarshallingType.LIST)
            .getter(getter(GetRelationalDatabasesResponse::relationalDatabases))
            .setter(setter(Builder::relationalDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalDatabases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelationalDatabase> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelationalDatabase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetRelationalDatabasesResponse::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATIONAL_DATABASES_FIELD,
            NEXT_PAGE_TOKEN_FIELD));

    private final List<RelationalDatabase> relationalDatabases;

    private final String nextPageToken;

    private GetRelationalDatabasesResponse(BuilderImpl builder) {
        super(builder);
        this.relationalDatabases = builder.relationalDatabases;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns true if the RelationalDatabases property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRelationalDatabases() {
        return relationalDatabases != null && !(relationalDatabases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object describing the result of your get relational databases request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelationalDatabases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object describing the result of your get relational databases request.
     */
    public List<RelationalDatabase> relationalDatabases() {
        return relationalDatabases;
    }

    /**
     * <p>
     * A token used for advancing to the next page of results from your get relational databases request.
     * </p>
     * 
     * @return A token used for advancing to the next page of results from your get relational databases request.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relationalDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRelationalDatabasesResponse)) {
            return false;
        }
        GetRelationalDatabasesResponse other = (GetRelationalDatabasesResponse) obj;
        return Objects.equals(relationalDatabases(), other.relationalDatabases())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetRelationalDatabasesResponse").add("RelationalDatabases", relationalDatabases())
                .add("NextPageToken", nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relationalDatabases":
            return Optional.ofNullable(clazz.cast(relationalDatabases()));
        case "nextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRelationalDatabasesResponse, T> g) {
        return obj -> g.apply((GetRelationalDatabasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRelationalDatabasesResponse> {
        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * 
         * @param relationalDatabases
         *        An object describing the result of your get relational databases request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabases(Collection<RelationalDatabase> relationalDatabases);

        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * 
         * @param relationalDatabases
         *        An object describing the result of your get relational databases request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationalDatabases(RelationalDatabase... relationalDatabases);

        /**
         * <p>
         * An object describing the result of your get relational databases request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RelationalDatabase>.Builder} avoiding the
         * need to create one manually via {@link List<RelationalDatabase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RelationalDatabase>.Builder#build()} is called immediately
         * and its result is passed to {@link #relationalDatabases(List<RelationalDatabase>)}.
         * 
         * @param relationalDatabases
         *        a consumer that will call methods on {@link List<RelationalDatabase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationalDatabases(List<RelationalDatabase>)
         */
        Builder relationalDatabases(Consumer<RelationalDatabase.Builder>... relationalDatabases);

        /**
         * <p>
         * A token used for advancing to the next page of results from your get relational databases request.
         * </p>
         * 
         * @param nextPageToken
         *        A token used for advancing to the next page of results from your get relational databases request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends LightsailResponse.BuilderImpl implements Builder {
        private List<RelationalDatabase> relationalDatabases = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRelationalDatabasesResponse model) {
            super(model);
            relationalDatabases(model.relationalDatabases);
            nextPageToken(model.nextPageToken);
        }

        public final Collection<RelationalDatabase.Builder> getRelationalDatabases() {
            return relationalDatabases != null ? relationalDatabases.stream().map(RelationalDatabase::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder relationalDatabases(Collection<RelationalDatabase> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copy(relationalDatabases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(RelationalDatabase... relationalDatabases) {
            relationalDatabases(Arrays.asList(relationalDatabases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalDatabases(Consumer<RelationalDatabase.Builder>... relationalDatabases) {
            relationalDatabases(Stream.of(relationalDatabases).map(c -> RelationalDatabase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRelationalDatabases(Collection<RelationalDatabase.BuilderImpl> relationalDatabases) {
            this.relationalDatabases = RelationalDatabaseListCopier.copyFromBuilder(relationalDatabases);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetRelationalDatabasesResponse build() {
            return new GetRelationalDatabasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
