/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of SSL/TLS certificate metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoadBalancerTlsCertificateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LoadBalancerTlsCertificateSummary.Builder, LoadBalancerTlsCertificateSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoadBalancerTlsCertificateSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> IS_ATTACHED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LoadBalancerTlsCertificateSummary::isAttached)).setter(setter(Builder::isAttached))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAttached").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(NAME_FIELD, IS_ATTACHED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Boolean isAttached;

    private LoadBalancerTlsCertificateSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.isAttached = builder.isAttached;
    }

    /**
     * <p>
     * The name of the SSL/TLS certificate.
     * </p>
     * 
     * @return The name of the SSL/TLS certificate.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
     * </p>
     * 
     * @return When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
     */
    public Boolean isAttached() {
        return isAttached;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(isAttached());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerTlsCertificateSummary)) {
            return false;
        }
        LoadBalancerTlsCertificateSummary other = (LoadBalancerTlsCertificateSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(isAttached(), other.isAttached());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoadBalancerTlsCertificateSummary").add("Name", name()).add("IsAttached", isAttached()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "isAttached":
            return Optional.ofNullable(clazz.cast(isAttached()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerTlsCertificateSummary, T> g) {
        return obj -> g.apply((LoadBalancerTlsCertificateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoadBalancerTlsCertificateSummary> {
        /**
         * <p>
         * The name of the SSL/TLS certificate.
         * </p>
         * 
         * @param name
         *        The name of the SSL/TLS certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
         * </p>
         * 
         * @param isAttached
         *        When <code>true</code>, the SSL/TLS certificate is attached to the Lightsail load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAttached(Boolean isAttached);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Boolean isAttached;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerTlsCertificateSummary model) {
            name(model.name);
            isAttached(model.isAttached);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getIsAttached() {
            return isAttached;
        }

        @Override
        public final Builder isAttached(Boolean isAttached) {
            this.isAttached = isAttached;
            return this;
        }

        public final void setIsAttached(Boolean isAttached) {
            this.isAttached = isAttached;
        }

        @Override
        public LoadBalancerTlsCertificateSummary build() {
            return new LoadBalancerTlsCertificateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
