/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MetricStatisticListCopier {
    static List<String> copy(Collection<String> metricStatisticListParam) {
        if (metricStatisticListParam == null || metricStatisticListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> metricStatisticListParamCopy = new ArrayList<>(metricStatisticListParam);
        return Collections.unmodifiableList(metricStatisticListParamCopy);
    }

    static List<String> copyEnumToString(Collection<MetricStatistic> metricStatisticListParam) {
        if (metricStatisticListParam == null || metricStatisticListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<String> metricStatisticListParamCopy = metricStatisticListParam.stream().map(Object::toString).collect(toList());
        return Collections.unmodifiableList(metricStatisticListParamCopy);
    }

    static List<MetricStatistic> copyStringToEnum(Collection<String> metricStatisticListParam) {
        if (metricStatisticListParam == null || metricStatisticListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<MetricStatistic> metricStatisticListParamCopy = metricStatisticListParam.stream().map(MetricStatistic::fromValue)
                .collect(toList());
        return Collections.unmodifiableList(metricStatisticListParamCopy);
    }
}
