/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the last time an access key was used.
 * </p>
 * <note>
 * <p>
 * This object does not include data in the response of a <a
 * href="https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html"
 * >CreateBucketAccessKey</a> action.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessKeyLastUsed implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessKeyLastUsed.Builder, AccessKeyLastUsed> {
    private static final SdkField<Instant> LAST_USED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUsedDate").getter(getter(AccessKeyLastUsed::lastUsedDate)).setter(setter(Builder::lastUsedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUsedDate").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(AccessKeyLastUsed::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(AccessKeyLastUsed::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_USED_DATE_FIELD,
            REGION_FIELD, SERVICE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant lastUsedDate;

    private final String region;

    private final String serviceName;

    private AccessKeyLastUsed(BuilderImpl builder) {
        this.lastUsedDate = builder.lastUsedDate;
        this.region = builder.region;
        this.serviceName = builder.serviceName;
    }

    /**
     * <p>
     * The date and time when the access key was most recently used.
     * </p>
     * <p>
     * This value is null if the access key has not been used.
     * </p>
     * 
     * @return The date and time when the access key was most recently used.</p>
     *         <p>
     *         This value is null if the access key has not been used.
     */
    public final Instant lastUsedDate() {
        return lastUsedDate;
    }

    /**
     * <p>
     * The AWS Region where this access key was most recently used.
     * </p>
     * <p>
     * This value is <code>N/A</code> if the access key has not been used.
     * </p>
     * 
     * @return The AWS Region where this access key was most recently used.</p>
     *         <p>
     *         This value is <code>N/A</code> if the access key has not been used.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The name of the AWS service with which this access key was most recently used.
     * </p>
     * <p>
     * This value is <code>N/A</code> if the access key has not been used.
     * </p>
     * 
     * @return The name of the AWS service with which this access key was most recently used.</p>
     *         <p>
     *         This value is <code>N/A</code> if the access key has not been used.
     */
    public final String serviceName() {
        return serviceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lastUsedDate());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyLastUsed)) {
            return false;
        }
        AccessKeyLastUsed other = (AccessKeyLastUsed) obj;
        return Objects.equals(lastUsedDate(), other.lastUsedDate()) && Objects.equals(region(), other.region())
                && Objects.equals(serviceName(), other.serviceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessKeyLastUsed").add("LastUsedDate", lastUsedDate()).add("Region", region())
                .add("ServiceName", serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lastUsedDate":
            return Optional.ofNullable(clazz.cast(lastUsedDate()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessKeyLastUsed, T> g) {
        return obj -> g.apply((AccessKeyLastUsed) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessKeyLastUsed> {
        /**
         * <p>
         * The date and time when the access key was most recently used.
         * </p>
         * <p>
         * This value is null if the access key has not been used.
         * </p>
         * 
         * @param lastUsedDate
         *        The date and time when the access key was most recently used.</p>
         *        <p>
         *        This value is null if the access key has not been used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUsedDate(Instant lastUsedDate);

        /**
         * <p>
         * The AWS Region where this access key was most recently used.
         * </p>
         * <p>
         * This value is <code>N/A</code> if the access key has not been used.
         * </p>
         * 
         * @param region
         *        The AWS Region where this access key was most recently used.</p>
         *        <p>
         *        This value is <code>N/A</code> if the access key has not been used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The name of the AWS service with which this access key was most recently used.
         * </p>
         * <p>
         * This value is <code>N/A</code> if the access key has not been used.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS service with which this access key was most recently used.</p>
         *        <p>
         *        This value is <code>N/A</code> if the access key has not been used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);
    }

    static final class BuilderImpl implements Builder {
        private Instant lastUsedDate;

        private String region;

        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyLastUsed model) {
            lastUsedDate(model.lastUsedDate);
            region(model.region);
            serviceName(model.serviceName);
        }

        public final Instant getLastUsedDate() {
            return lastUsedDate;
        }

        public final void setLastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
        }

        @Override
        public final Builder lastUsedDate(Instant lastUsedDate) {
            this.lastUsedDate = lastUsedDate;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public AccessKeyLastUsed build() {
            return new AccessKeyLastUsed(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
