/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCertificatesRequest extends LightsailRequest implements
        ToCopyableBuilder<GetCertificatesRequest.Builder, GetCertificatesRequest> {
    private static final SdkField<List<String>> CERTIFICATE_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("certificateStatuses")
            .getter(getter(GetCertificatesRequest::certificateStatusesAsStrings))
            .setter(setter(Builder::certificateStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_CERTIFICATE_DETAILS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("includeCertificateDetails")
            .getter(getter(GetCertificatesRequest::includeCertificateDetails)).setter(setter(Builder::includeCertificateDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeCertificateDetails").build())
            .build();

    private static final SdkField<String> CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateName").getter(getter(GetCertificatesRequest::certificateName))
            .setter(setter(Builder::certificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_STATUSES_FIELD,
            INCLUDE_CERTIFICATE_DETAILS_FIELD, CERTIFICATE_NAME_FIELD));

    private final List<String> certificateStatuses;

    private final Boolean includeCertificateDetails;

    private final String certificateName;

    private GetCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateStatuses = builder.certificateStatuses;
        this.includeCertificateDetails = builder.includeCertificateDetails;
        this.certificateName = builder.certificateName;
    }

    /**
     * <p>
     * The status of the certificates for which to return information.
     * </p>
     * <p>
     * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request
     * is made, regardless of their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateStatuses} method.
     * </p>
     * 
     * @return The status of the certificates for which to return information.</p>
     *         <p>
     *         For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     *         </p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
     *         request is made, regardless of their current status.
     */
    public final List<CertificateStatus> certificateStatuses() {
        return CertificateStatusListCopier.copyStringToEnum(certificateStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateStatuses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificateStatuses() {
        return certificateStatuses != null && !(certificateStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of the certificates for which to return information.
     * </p>
     * <p>
     * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request
     * is made, regardless of their current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateStatuses} method.
     * </p>
     * 
     * @return The status of the certificates for which to return information.</p>
     *         <p>
     *         For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
     *         </p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
     *         request is made, regardless of their current status.
     */
    public final List<String> certificateStatusesAsStrings() {
        return certificateStatuses;
    }

    /**
     * <p>
     * Indicates whether to include detailed information about the certificates in the response.
     * </p>
     * <p>
     * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names, and
     * tags.
     * </p>
     * 
     * @return Indicates whether to include detailed information about the certificates in the response.</p>
     *         <p>
     *         When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain
     *         names, and tags.
     */
    public final Boolean includeCertificateDetails() {
        return includeCertificateDetails;
    }

    /**
     * <p>
     * The name for the certificate for which to return information.
     * </p>
     * <p>
     * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the request
     * is made.
     * </p>
     * 
     * @return The name for the certificate for which to return information.</p>
     *         <p>
     *         When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
     *         request is made.
     */
    public final String certificateName() {
        return certificateName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateStatuses() ? certificateStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(includeCertificateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(certificateName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCertificatesRequest)) {
            return false;
        }
        GetCertificatesRequest other = (GetCertificatesRequest) obj;
        return hasCertificateStatuses() == other.hasCertificateStatuses()
                && Objects.equals(certificateStatusesAsStrings(), other.certificateStatusesAsStrings())
                && Objects.equals(includeCertificateDetails(), other.includeCertificateDetails())
                && Objects.equals(certificateName(), other.certificateName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCertificatesRequest")
                .add("CertificateStatuses", hasCertificateStatuses() ? certificateStatusesAsStrings() : null)
                .add("IncludeCertificateDetails", includeCertificateDetails()).add("CertificateName", certificateName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateStatuses":
            return Optional.ofNullable(clazz.cast(certificateStatusesAsStrings()));
        case "includeCertificateDetails":
            return Optional.ofNullable(clazz.cast(includeCertificateDetails()));
        case "certificateName":
            return Optional.ofNullable(clazz.cast(certificateName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCertificatesRequest, T> g) {
        return obj -> g.apply((GetCertificatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LightsailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCertificatesRequest> {
        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
         * request is made, regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the Amazon Web Services Region where
         *        the request is made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatusesWithStrings(Collection<String> certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
         * request is made, regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the Amazon Web Services Region where
         *        the request is made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatusesWithStrings(String... certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
         * request is made, regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the Amazon Web Services Region where
         *        the request is made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses);

        /**
         * <p>
         * The status of the certificates for which to return information.
         * </p>
         * <p>
         * For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code> status.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
         * request is made, regardless of their current status.
         * </p>
         * 
         * @param certificateStatuses
         *        The status of the certificates for which to return information.</p>
         *        <p>
         *        For example, specify <code>ISSUED</code> to return only certificates with an <code>ISSUED</code>
         *        status.
         *        </p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the Amazon Web Services Region where
         *        the request is made, regardless of their current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateStatuses(CertificateStatus... certificateStatuses);

        /**
         * <p>
         * Indicates whether to include detailed information about the certificates in the response.
         * </p>
         * <p>
         * When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain names,
         * and tags.
         * </p>
         * 
         * @param includeCertificateDetails
         *        Indicates whether to include detailed information about the certificates in the response.</p>
         *        <p>
         *        When omitted, the response includes only the certificate names, Amazon Resource Names (ARNs), domain
         *        names, and tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCertificateDetails(Boolean includeCertificateDetails);

        /**
         * <p>
         * The name for the certificate for which to return information.
         * </p>
         * <p>
         * When omitted, the response includes all of your certificates in the Amazon Web Services Region where the
         * request is made.
         * </p>
         * 
         * @param certificateName
         *        The name for the certificate for which to return information.</p>
         *        <p>
         *        When omitted, the response includes all of your certificates in the Amazon Web Services Region where
         *        the request is made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateName(String certificateName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LightsailRequest.BuilderImpl implements Builder {
        private List<String> certificateStatuses = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeCertificateDetails;

        private String certificateName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCertificatesRequest model) {
            super(model);
            certificateStatusesWithStrings(model.certificateStatuses);
            includeCertificateDetails(model.includeCertificateDetails);
            certificateName(model.certificateName);
        }

        public final Collection<String> getCertificateStatuses() {
            if (certificateStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateStatuses;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
        }

        @Override
        public final Builder certificateStatusesWithStrings(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatusesWithStrings(String... certificateStatuses) {
            certificateStatusesWithStrings(Arrays.asList(certificateStatuses));
            return this;
        }

        @Override
        public final Builder certificateStatuses(Collection<CertificateStatus> certificateStatuses) {
            this.certificateStatuses = CertificateStatusListCopier.copyEnumToString(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(CertificateStatus... certificateStatuses) {
            certificateStatuses(Arrays.asList(certificateStatuses));
            return this;
        }

        public final Boolean getIncludeCertificateDetails() {
            return includeCertificateDetails;
        }

        public final void setIncludeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
        }

        @Override
        public final Builder includeCertificateDetails(Boolean includeCertificateDetails) {
            this.includeCertificateDetails = includeCertificateDetails;
            return this;
        }

        public final String getCertificateName() {
            return certificateName;
        }

        public final void setCertificateName(String certificateName) {
            this.certificateName = certificateName;
        }

        @Override
        public final Builder certificateName(String certificateName) {
            this.certificateName = certificateName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCertificatesRequest build() {
            return new GetCertificatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
