/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse;

public class ListSensorStatisticsIterable
implements SdkIterable<ListSensorStatisticsResponse> {
    private final LookoutEquipmentClient client;
    private final ListSensorStatisticsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSensorStatisticsIterable(LookoutEquipmentClient client, ListSensorStatisticsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSensorStatisticsResponseFetcher();
    }

    public Iterator<ListSensorStatisticsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSensorStatisticsResponseFetcher
    implements SyncPageFetcher<ListSensorStatisticsResponse> {
        private ListSensorStatisticsResponseFetcher() {
        }

        public boolean hasNextPage(ListSensorStatisticsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSensorStatisticsResponse nextPage(ListSensorStatisticsResponse previousPage) {
            if (previousPage == null) {
                return ListSensorStatisticsIterable.this.client.listSensorStatistics(ListSensorStatisticsIterable.this.firstRequest);
            }
            return ListSensorStatisticsIterable.this.client.listSensorStatistics((ListSensorStatisticsRequest)((Object)ListSensorStatisticsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

