/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.Action;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertStatus;
import software.amazon.awssdk.services.lookoutmetrics.model.AlertType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alert
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Alert> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(Alert.getter(Alert::action)).setter(Alert.setter(Builder::action)).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertDescription").getter(Alert.getter(Alert::alertDescription)).setter(Alert.setter(Builder::alertDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()}).build();
    private static final SdkField<String> ALERT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertArn").getter(Alert.getter(Alert::alertArn)).setter(Alert.setter(Builder::alertArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertArn").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyDetectorArn").getter(Alert.getter(Alert::anomalyDetectorArn)).setter(Alert.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build()}).build();
    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertName").getter(Alert.getter(Alert::alertName)).setter(Alert.setter(Builder::alertName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()}).build();
    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AlertSensitivityThreshold").getter(Alert.getter(Alert::alertSensitivityThreshold)).setter(Alert.setter(Builder::alertSensitivityThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build()}).build();
    private static final SdkField<String> ALERT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertType").getter(Alert.getter(Alert::alertTypeAsString)).setter(Alert.setter(Builder::alertType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertType").build()}).build();
    private static final SdkField<String> ALERT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlertStatus").getter(Alert.getter(Alert::alertStatusAsString)).setter(Alert.setter(Builder::alertStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModificationTime").getter(Alert.getter(Alert::lastModificationTime)).setter(Alert.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Alert.getter(Alert::creationTime)).setter(Alert.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ALERT_DESCRIPTION_FIELD, ALERT_ARN_FIELD, ANOMALY_DETECTOR_ARN_FIELD, ALERT_NAME_FIELD, ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_TYPE_FIELD, ALERT_STATUS_FIELD, LAST_MODIFICATION_TIME_FIELD, CREATION_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Action action;
    private final String alertDescription;
    private final String alertArn;
    private final String anomalyDetectorArn;
    private final String alertName;
    private final Integer alertSensitivityThreshold;
    private final String alertType;
    private final String alertStatus;
    private final Instant lastModificationTime;
    private final Instant creationTime;

    private Alert(BuilderImpl builder) {
        this.action = builder.action;
        this.alertDescription = builder.alertDescription;
        this.alertArn = builder.alertArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertType = builder.alertType;
        this.alertStatus = builder.alertStatus;
        this.lastModificationTime = builder.lastModificationTime;
        this.creationTime = builder.creationTime;
    }

    public final Action action() {
        return this.action;
    }

    public final String alertDescription() {
        return this.alertDescription;
    }

    public final String alertArn() {
        return this.alertArn;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String alertName() {
        return this.alertName;
    }

    public final Integer alertSensitivityThreshold() {
        return this.alertSensitivityThreshold;
    }

    public final AlertType alertType() {
        return AlertType.fromValue(this.alertType);
    }

    public final String alertTypeAsString() {
        return this.alertType;
    }

    public final AlertStatus alertStatus() {
        return AlertStatus.fromValue(this.alertStatus);
    }

    public final String alertStatusAsString() {
        return this.alertStatus;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.alertDescription(), other.alertDescription()) && Objects.equals(this.alertArn(), other.alertArn()) && Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.alertName(), other.alertName()) && Objects.equals(this.alertSensitivityThreshold(), other.alertSensitivityThreshold()) && Objects.equals(this.alertTypeAsString(), other.alertTypeAsString()) && Objects.equals(this.alertStatusAsString(), other.alertStatusAsString()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime()) && Objects.equals(this.creationTime(), other.creationTime());
    }

    public final String toString() {
        return ToString.builder((String)"Alert").add("Action", (Object)this.action()).add("AlertDescription", (Object)this.alertDescription()).add("AlertArn", (Object)this.alertArn()).add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("AlertName", (Object)this.alertName()).add("AlertSensitivityThreshold", (Object)this.alertSensitivityThreshold()).add("AlertType", (Object)this.alertTypeAsString()).add("AlertStatus", (Object)this.alertStatusAsString()).add("LastModificationTime", (Object)this.lastModificationTime()).add("CreationTime", (Object)this.creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "AlertDescription": {
                return Optional.ofNullable(clazz.cast(this.alertDescription()));
            }
            case "AlertArn": {
                return Optional.ofNullable(clazz.cast(this.alertArn()));
            }
            case "AnomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "AlertName": {
                return Optional.ofNullable(clazz.cast(this.alertName()));
            }
            case "AlertSensitivityThreshold": {
                return Optional.ofNullable(clazz.cast(this.alertSensitivityThreshold()));
            }
            case "AlertType": {
                return Optional.ofNullable(clazz.cast(this.alertTypeAsString()));
            }
            case "AlertStatus": {
                return Optional.ofNullable(clazz.cast(this.alertStatusAsString()));
            }
            case "LastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Alert, T> g) {
        return obj -> g.apply((Alert)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Action action;
        private String alertDescription;
        private String alertArn;
        private String anomalyDetectorArn;
        private String alertName;
        private Integer alertSensitivityThreshold;
        private String alertType;
        private String alertStatus;
        private Instant lastModificationTime;
        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Alert model) {
            this.action(model.action);
            this.alertDescription(model.alertDescription);
            this.alertArn(model.alertArn);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.alertName(model.alertName);
            this.alertSensitivityThreshold(model.alertSensitivityThreshold);
            this.alertType(model.alertType);
            this.alertStatus(model.alertStatus);
            this.lastModificationTime(model.lastModificationTime);
            this.creationTime(model.creationTime);
        }

        public final Action.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final String getAlertDescription() {
            return this.alertDescription;
        }

        @Override
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        public final String getAlertArn() {
            return this.alertArn;
        }

        @Override
        public final Builder alertArn(String alertArn) {
            this.alertArn = alertArn;
            return this;
        }

        public final void setAlertArn(String alertArn) {
            this.alertArn = alertArn;
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        public final String getAlertName() {
            return this.alertName;
        }

        @Override
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        public final Integer getAlertSensitivityThreshold() {
            return this.alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        public final String getAlertType() {
            return this.alertType;
        }

        @Override
        public final Builder alertType(String alertType) {
            this.alertType = alertType;
            return this;
        }

        @Override
        public final Builder alertType(AlertType alertType) {
            this.alertType(alertType == null ? null : alertType.toString());
            return this;
        }

        public final void setAlertType(String alertType) {
            this.alertType = alertType;
        }

        public final String getAlertStatus() {
            return this.alertStatus;
        }

        @Override
        public final Builder alertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
            return this;
        }

        @Override
        public final Builder alertStatus(AlertStatus alertStatus) {
            this.alertStatus(alertStatus == null ? null : alertStatus.toString());
            return this;
        }

        public final void setAlertStatus(String alertStatus) {
            this.alertStatus = alertStatus;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public Alert build() {
            return new Alert(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Alert> {
        public Builder action(Action var1);

        default public Builder action(Consumer<Action.Builder> action) {
            return this.action((Action)((Action.Builder)Action.builder().applyMutation(action)).build());
        }

        public Builder alertDescription(String var1);

        public Builder alertArn(String var1);

        public Builder anomalyDetectorArn(String var1);

        public Builder alertName(String var1);

        public Builder alertSensitivityThreshold(Integer var1);

        public Builder alertType(String var1);

        public Builder alertType(AlertType var1);

        public Builder alertStatus(String var1);

        public Builder alertStatus(AlertStatus var1);

        public Builder lastModificationTime(Instant var1);

        public Builder creationTime(Instant var1);
    }
}

