/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.SecurityGroupIdListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.SubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcConfiguration> {
    private static final SdkField<List<String>> SUBNET_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIdList").getter(VpcConfiguration.getter(VpcConfiguration::subnetIdList)).setter(VpcConfiguration.setter(Builder::subnetIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIdList").getter(VpcConfiguration.getter(VpcConfiguration::securityGroupIdList)).setter(VpcConfiguration.setter(Builder::securityGroupIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_LIST_FIELD, SECURITY_GROUP_ID_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> subnetIdList;
    private final List<String> securityGroupIdList;

    private VpcConfiguration(BuilderImpl builder) {
        this.subnetIdList = builder.subnetIdList;
        this.securityGroupIdList = builder.securityGroupIdList;
    }

    public final boolean hasSubnetIdList() {
        return this.subnetIdList != null && !(this.subnetIdList instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIdList() {
        return this.subnetIdList;
    }

    public final boolean hasSecurityGroupIdList() {
        return this.securityGroupIdList != null && !(this.securityGroupIdList instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIdList() {
        return this.securityGroupIdList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIdList() ? this.subnetIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfiguration)) {
            return false;
        }
        VpcConfiguration other = (VpcConfiguration)obj;
        return this.hasSubnetIdList() == other.hasSubnetIdList() && Objects.equals(this.subnetIdList(), other.subnetIdList()) && this.hasSecurityGroupIdList() == other.hasSecurityGroupIdList() && Objects.equals(this.securityGroupIdList(), other.securityGroupIdList());
    }

    public final String toString() {
        return ToString.builder((String)"VpcConfiguration").add("SubnetIdList", this.hasSubnetIdList() ? this.subnetIdList() : null).add("SecurityGroupIdList", this.hasSecurityGroupIdList() ? this.securityGroupIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdList": {
                return Optional.ofNullable(clazz.cast(this.subnetIdList()));
            }
            case "SecurityGroupIdList": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfiguration, T> g) {
        return obj -> g.apply((VpcConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnetIdList = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfiguration model) {
            this.subnetIdList(model.subnetIdList);
            this.securityGroupIdList(model.securityGroupIdList);
        }

        public final Collection<String> getSubnetIdList() {
            if (this.subnetIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIdList;
        }

        @Override
        public final Builder subnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIdList(String ... subnetIdList) {
            this.subnetIdList(Arrays.asList(subnetIdList));
            return this;
        }

        public final void setSubnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (this.securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIdList;
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String ... securityGroupIdList) {
            this.securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        public VpcConfiguration build() {
            return new VpcConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcConfiguration> {
        public Builder subnetIdList(Collection<String> var1);

        public Builder subnetIdList(String ... var1);

        public Builder securityGroupIdList(Collection<String> var1);

        public Builder securityGroupIdList(String ... var1);
    }
}

