/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.CSVFileCompression;
import software.amazon.awssdk.services.lookoutmetrics.model.HeaderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CsvFormatDescriptor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CsvFormatDescriptor> {
    private static final SdkField<String> FILE_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCompression").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::fileCompressionAsString)).setter(CsvFormatDescriptor.setter(Builder::fileCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()}).build();
    private static final SdkField<String> CHARSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Charset").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::charset)).setter(CsvFormatDescriptor.setter(Builder::charset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()}).build();
    private static final SdkField<Boolean> CONTAINS_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ContainsHeader").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::containsHeader)).setter(CsvFormatDescriptor.setter(Builder::containsHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()}).build();
    private static final SdkField<String> DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Delimiter").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::delimiter)).setter(CsvFormatDescriptor.setter(Builder::delimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()}).build();
    private static final SdkField<List<String>> HEADER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeaderList").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::headerList)).setter(CsvFormatDescriptor.setter(Builder::headerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> QUOTE_SYMBOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuoteSymbol").getter(CsvFormatDescriptor.getter(CsvFormatDescriptor::quoteSymbol)).setter(CsvFormatDescriptor.setter(Builder::quoteSymbol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteSymbol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD, CHARSET_FIELD, CONTAINS_HEADER_FIELD, DELIMITER_FIELD, HEADER_LIST_FIELD, QUOTE_SYMBOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileCompression;
    private final String charset;
    private final Boolean containsHeader;
    private final String delimiter;
    private final List<String> headerList;
    private final String quoteSymbol;

    private CsvFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
        this.containsHeader = builder.containsHeader;
        this.delimiter = builder.delimiter;
        this.headerList = builder.headerList;
        this.quoteSymbol = builder.quoteSymbol;
    }

    public final CSVFileCompression fileCompression() {
        return CSVFileCompression.fromValue(this.fileCompression);
    }

    public final String fileCompressionAsString() {
        return this.fileCompression;
    }

    public final String charset() {
        return this.charset;
    }

    public final Boolean containsHeader() {
        return this.containsHeader;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final boolean hasHeaderList() {
        return this.headerList != null && !(this.headerList instanceof SdkAutoConstructList);
    }

    public final List<String> headerList() {
        return this.headerList;
    }

    public final String quoteSymbol() {
        return this.quoteSymbol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.charset());
        hashCode = 31 * hashCode + Objects.hashCode(this.containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(this.delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderList() ? this.headerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteSymbol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvFormatDescriptor)) {
            return false;
        }
        CsvFormatDescriptor other = (CsvFormatDescriptor)obj;
        return Objects.equals(this.fileCompressionAsString(), other.fileCompressionAsString()) && Objects.equals(this.charset(), other.charset()) && Objects.equals(this.containsHeader(), other.containsHeader()) && Objects.equals(this.delimiter(), other.delimiter()) && this.hasHeaderList() == other.hasHeaderList() && Objects.equals(this.headerList(), other.headerList()) && Objects.equals(this.quoteSymbol(), other.quoteSymbol());
    }

    public final String toString() {
        return ToString.builder((String)"CsvFormatDescriptor").add("FileCompression", (Object)this.fileCompressionAsString()).add("Charset", (Object)this.charset()).add("ContainsHeader", (Object)this.containsHeader()).add("Delimiter", (Object)this.delimiter()).add("HeaderList", this.hasHeaderList() ? this.headerList() : null).add("QuoteSymbol", (Object)this.quoteSymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FileCompression": {
                return Optional.ofNullable(clazz.cast(this.fileCompressionAsString()));
            }
            case "Charset": {
                return Optional.ofNullable(clazz.cast(this.charset()));
            }
            case "ContainsHeader": {
                return Optional.ofNullable(clazz.cast(this.containsHeader()));
            }
            case "Delimiter": {
                return Optional.ofNullable(clazz.cast(this.delimiter()));
            }
            case "HeaderList": {
                return Optional.ofNullable(clazz.cast(this.headerList()));
            }
            case "QuoteSymbol": {
                return Optional.ofNullable(clazz.cast(this.quoteSymbol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CsvFormatDescriptor, T> g) {
        return obj -> g.apply((CsvFormatDescriptor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileCompression;
        private String charset;
        private Boolean containsHeader;
        private String delimiter;
        private List<String> headerList = DefaultSdkAutoConstructList.getInstance();
        private String quoteSymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvFormatDescriptor model) {
            this.fileCompression(model.fileCompression);
            this.charset(model.charset);
            this.containsHeader(model.containsHeader);
            this.delimiter(model.delimiter);
            this.headerList(model.headerList);
            this.quoteSymbol(model.quoteSymbol);
        }

        public final String getFileCompression() {
            return this.fileCompression;
        }

        public final void setFileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
        }

        @Override
        @Transient
        public final Builder fileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        @Override
        @Transient
        public final Builder fileCompression(CSVFileCompression fileCompression) {
            this.fileCompression(fileCompression == null ? null : fileCompression.toString());
            return this;
        }

        public final String getCharset() {
            return this.charset;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        @Transient
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final Boolean getContainsHeader() {
            return this.containsHeader;
        }

        public final void setContainsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
        }

        @Override
        @Transient
        public final Builder containsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final String getDelimiter() {
            return this.delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        @Transient
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final Collection<String> getHeaderList() {
            if (this.headerList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.headerList;
        }

        public final void setHeaderList(Collection<String> headerList) {
            this.headerList = HeaderListCopier.copy(headerList);
        }

        @Override
        @Transient
        public final Builder headerList(Collection<String> headerList) {
            this.headerList = HeaderListCopier.copy(headerList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headerList(String ... headerList) {
            this.headerList(Arrays.asList(headerList));
            return this;
        }

        public final String getQuoteSymbol() {
            return this.quoteSymbol;
        }

        public final void setQuoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
        }

        @Override
        @Transient
        public final Builder quoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        public CsvFormatDescriptor build() {
            return new CsvFormatDescriptor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CsvFormatDescriptor> {
        public Builder fileCompression(String var1);

        public Builder fileCompression(CSVFileCompression var1);

        public Builder charset(String var1);

        public Builder containsHeader(Boolean var1);

        public Builder delimiter(String var1);

        public Builder headerList(Collection<String> var1);

        public Builder headerList(String ... var1);

        public Builder quoteSymbol(String var1);
    }
}

