/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListAnomalyDetectorsResponse;

public class ListAnomalyDetectorsIterable
implements SdkIterable<ListAnomalyDetectorsResponse> {
    private final LookoutMetricsClient client;
    private final ListAnomalyDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAnomalyDetectorsIterable(LookoutMetricsClient client, ListAnomalyDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAnomalyDetectorsResponseFetcher();
    }

    public Iterator<ListAnomalyDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAnomalyDetectorsResponseFetcher
    implements SyncPageFetcher<ListAnomalyDetectorsResponse> {
        private ListAnomalyDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListAnomalyDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAnomalyDetectorsResponse nextPage(ListAnomalyDetectorsResponse previousPage) {
            if (previousPage == null) {
                return ListAnomalyDetectorsIterable.this.client.listAnomalyDetectors(ListAnomalyDetectorsIterable.this.firstRequest);
            }
            return ListAnomalyDetectorsIterable.this.client.listAnomalyDetectors((ListAnomalyDetectorsRequest)((Object)ListAnomalyDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

