/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutmetrics.LookoutMetricsClient;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsRequest;
import software.amazon.awssdk.services.lookoutmetrics.model.ListMetricSetsResponse;

public class ListMetricSetsIterable
implements SdkIterable<ListMetricSetsResponse> {
    private final LookoutMetricsClient client;
    private final ListMetricSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricSetsIterable(LookoutMetricsClient client, ListMetricSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMetricSetsResponseFetcher();
    }

    public Iterator<ListMetricSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMetricSetsResponseFetcher
    implements SyncPageFetcher<ListMetricSetsResponse> {
        private ListMetricSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricSetsResponse nextPage(ListMetricSetsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricSetsIterable.this.client.listMetricSets(ListMetricSetsIterable.this.firstRequest);
            }
            return ListMetricSetsIterable.this.client.listMetricSets((ListMetricSetsRequest)((Object)ListMetricSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

