/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAlertResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<DescribeAlertResponse.Builder, DescribeAlertResponse> {
    private static final SdkField<Alert> ALERT_FIELD = SdkField.<Alert> builder(MarshallingType.SDK_POJO).memberName("Alert")
            .getter(getter(DescribeAlertResponse::alert)).setter(setter(Builder::alert)).constructor(Alert::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alert").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_FIELD));

    private final Alert alert;

    private DescribeAlertResponse(BuilderImpl builder) {
        super(builder);
        this.alert = builder.alert;
    }

    /**
     * <p>
     * Contains information about an alert.
     * </p>
     * 
     * @return Contains information about an alert.
     */
    public final Alert alert() {
        return alert;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alert());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlertResponse)) {
            return false;
        }
        DescribeAlertResponse other = (DescribeAlertResponse) obj;
        return Objects.equals(alert(), other.alert());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAlertResponse").add("Alert", alert()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Alert":
            return Optional.ofNullable(clazz.cast(alert()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlertResponse, T> g) {
        return obj -> g.apply((DescribeAlertResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAlertResponse> {
        /**
         * <p>
         * Contains information about an alert.
         * </p>
         * 
         * @param alert
         *        Contains information about an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alert(Alert alert);

        /**
         * <p>
         * Contains information about an alert.
         * </p>
         * This is a convenience method that creates an instance of the {@link Alert.Builder} avoiding the need to
         * create one manually via {@link Alert#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Alert.Builder#build()} is called immediately and its result is
         * passed to {@link #alert(Alert)}.
         * 
         * @param alert
         *        a consumer that will call methods on {@link Alert.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alert(Alert)
         */
        default Builder alert(Consumer<Alert.Builder> alert) {
            return alert(Alert.builder().applyMutation(alert).build());
        }
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private Alert alert;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlertResponse model) {
            super(model);
            alert(model.alert);
        }

        public final Alert.Builder getAlert() {
            return alert != null ? alert.toBuilder() : null;
        }

        public final void setAlert(Alert.BuilderImpl alert) {
            this.alert = alert != null ? alert.build() : null;
        }

        @Override
        public final Builder alert(Alert alert) {
            this.alert = alert;
            return this;
        }

        @Override
        public DescribeAlertResponse build() {
            return new DescribeAlertResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
