/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a measure affected by an anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricLevelImpact implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricLevelImpact.Builder, MetricLevelImpact> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricLevelImpact::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Integer> NUM_TIME_SERIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumTimeSeries").getter(getter(MetricLevelImpact::numTimeSeries)).setter(setter(Builder::numTimeSeries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTimeSeries").build()).build();

    private static final SdkField<ContributionMatrix> CONTRIBUTION_MATRIX_FIELD = SdkField
            .<ContributionMatrix> builder(MarshallingType.SDK_POJO).memberName("ContributionMatrix")
            .getter(getter(MetricLevelImpact::contributionMatrix)).setter(setter(Builder::contributionMatrix))
            .constructor(ContributionMatrix::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionMatrix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            NUM_TIME_SERIES_FIELD, CONTRIBUTION_MATRIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final Integer numTimeSeries;

    private final ContributionMatrix contributionMatrix;

    private MetricLevelImpact(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.numTimeSeries = builder.numTimeSeries;
        this.contributionMatrix = builder.contributionMatrix;
    }

    /**
     * <p>
     * The name of the measure.
     * </p>
     * 
     * @return The name of the measure.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The number of anomalous metrics for the measure.
     * </p>
     * 
     * @return The number of anomalous metrics for the measure.
     */
    public final Integer numTimeSeries() {
        return numTimeSeries;
    }

    /**
     * <p>
     * Details about the dimensions that contributed to the anomaly.
     * </p>
     * 
     * @return Details about the dimensions that contributed to the anomaly.
     */
    public final ContributionMatrix contributionMatrix() {
        return contributionMatrix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(numTimeSeries());
        hashCode = 31 * hashCode + Objects.hashCode(contributionMatrix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricLevelImpact)) {
            return false;
        }
        MetricLevelImpact other = (MetricLevelImpact) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(numTimeSeries(), other.numTimeSeries())
                && Objects.equals(contributionMatrix(), other.contributionMatrix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricLevelImpact").add("MetricName", metricName()).add("NumTimeSeries", numTimeSeries())
                .add("ContributionMatrix", contributionMatrix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "NumTimeSeries":
            return Optional.ofNullable(clazz.cast(numTimeSeries()));
        case "ContributionMatrix":
            return Optional.ofNullable(clazz.cast(contributionMatrix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricLevelImpact, T> g) {
        return obj -> g.apply((MetricLevelImpact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricLevelImpact> {
        /**
         * <p>
         * The name of the measure.
         * </p>
         * 
         * @param metricName
         *        The name of the measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The number of anomalous metrics for the measure.
         * </p>
         * 
         * @param numTimeSeries
         *        The number of anomalous metrics for the measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numTimeSeries(Integer numTimeSeries);

        /**
         * <p>
         * Details about the dimensions that contributed to the anomaly.
         * </p>
         * 
         * @param contributionMatrix
         *        Details about the dimensions that contributed to the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionMatrix(ContributionMatrix contributionMatrix);

        /**
         * <p>
         * Details about the dimensions that contributed to the anomaly.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContributionMatrix.Builder} avoiding the
         * need to create one manually via {@link ContributionMatrix#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContributionMatrix.Builder#build()} is called immediately and its
         * result is passed to {@link #contributionMatrix(ContributionMatrix)}.
         * 
         * @param contributionMatrix
         *        a consumer that will call methods on {@link ContributionMatrix.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributionMatrix(ContributionMatrix)
         */
        default Builder contributionMatrix(Consumer<ContributionMatrix.Builder> contributionMatrix) {
            return contributionMatrix(ContributionMatrix.builder().applyMutation(contributionMatrix).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private Integer numTimeSeries;

        private ContributionMatrix contributionMatrix;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricLevelImpact model) {
            metricName(model.metricName);
            numTimeSeries(model.numTimeSeries);
            contributionMatrix(model.contributionMatrix);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Integer getNumTimeSeries() {
            return numTimeSeries;
        }

        public final void setNumTimeSeries(Integer numTimeSeries) {
            this.numTimeSeries = numTimeSeries;
        }

        @Override
        public final Builder numTimeSeries(Integer numTimeSeries) {
            this.numTimeSeries = numTimeSeries;
            return this;
        }

        public final ContributionMatrix.Builder getContributionMatrix() {
            return contributionMatrix != null ? contributionMatrix.toBuilder() : null;
        }

        public final void setContributionMatrix(ContributionMatrix.BuilderImpl contributionMatrix) {
            this.contributionMatrix = contributionMatrix != null ? contributionMatrix.build() : null;
        }

        @Override
        public final Builder contributionMatrix(ContributionMatrix contributionMatrix) {
            this.contributionMatrix = contributionMatrix;
            return this;
        }

        @Override
        public MetricLevelImpact build() {
            return new MetricLevelImpact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
