/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information about the Amazon Virtual Private Cloud (VPC).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfiguration.Builder, VpcConfiguration> {
    private static final SdkField<List<String>> SUBNET_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIdList")
            .getter(getter(VpcConfiguration::subnetIdList))
            .setter(setter(Builder::subnetIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIdList")
            .getter(getter(VpcConfiguration::securityGroupIdList))
            .setter(setter(Builder::securityGroupIdList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_LIST_FIELD,
            SECURITY_GROUP_ID_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> subnetIdList;

    private final List<String> securityGroupIdList;

    private VpcConfiguration(BuilderImpl builder) {
        this.subnetIdList = builder.subnetIdList;
        this.securityGroupIdList = builder.securityGroupIdList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIdList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetIdList() {
        return subnetIdList != null && !(subnetIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIdList} method.
     * </p>
     * 
     * @return An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
     */
    public final List<String> subnetIdList() {
        return subnetIdList;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIdList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIdList() {
        return securityGroupIdList != null && !(securityGroupIdList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings containing the list of security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIdList} method.
     * </p>
     * 
     * @return An array of strings containing the list of security groups.
     */
    public final List<String> securityGroupIdList() {
        return securityGroupIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIdList() ? subnetIdList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdList() ? securityGroupIdList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfiguration)) {
            return false;
        }
        VpcConfiguration other = (VpcConfiguration) obj;
        return hasSubnetIdList() == other.hasSubnetIdList() && Objects.equals(subnetIdList(), other.subnetIdList())
                && hasSecurityGroupIdList() == other.hasSecurityGroupIdList()
                && Objects.equals(securityGroupIdList(), other.securityGroupIdList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfiguration").add("SubnetIdList", hasSubnetIdList() ? subnetIdList() : null)
                .add("SecurityGroupIdList", hasSecurityGroupIdList() ? securityGroupIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubnetIdList":
            return Optional.ofNullable(clazz.cast(subnetIdList()));
        case "SecurityGroupIdList":
            return Optional.ofNullable(clazz.cast(securityGroupIdList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VpcConfiguration, T> g) {
        return obj -> g.apply((VpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfiguration> {
        /**
         * <p>
         * An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
         * </p>
         * 
         * @param subnetIdList
         *        An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdList(Collection<String> subnetIdList);

        /**
         * <p>
         * An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
         * </p>
         * 
         * @param subnetIdList
         *        An array of strings containing the Amazon VPC subnet IDs (e.g., <code>subnet-0bb1c79de3EXAMPLE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIdList(String... subnetIdList);

        /**
         * <p>
         * An array of strings containing the list of security groups.
         * </p>
         * 
         * @param securityGroupIdList
         *        An array of strings containing the list of security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(Collection<String> securityGroupIdList);

        /**
         * <p>
         * An array of strings containing the list of security groups.
         * </p>
         * 
         * @param securityGroupIdList
         *        An array of strings containing the list of security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdList(String... securityGroupIdList);
    }

    static final class BuilderImpl implements Builder {
        private List<String> subnetIdList = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfiguration model) {
            subnetIdList(model.subnetIdList);
            securityGroupIdList(model.securityGroupIdList);
        }

        public final Collection<String> getSubnetIdList() {
            if (subnetIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIdList;
        }

        public final void setSubnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
        }

        @Override
        public final Builder subnetIdList(Collection<String> subnetIdList) {
            this.subnetIdList = SubnetIdListCopier.copy(subnetIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIdList(String... subnetIdList) {
            subnetIdList(Arrays.asList(subnetIdList));
            return this;
        }

        public final Collection<String> getSecurityGroupIdList() {
            if (securityGroupIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdList;
        }

        public final void setSecurityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
        }

        @Override
        public final Builder securityGroupIdList(Collection<String> securityGroupIdList) {
            this.securityGroupIdList = SecurityGroupIdListCopier.copy(securityGroupIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdList(String... securityGroupIdList) {
            securityGroupIdList(Arrays.asList(securityGroupIdList));
            return this;
        }

        @Override
        public VpcConfiguration build() {
            return new VpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
