/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.DimensionValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionFilter> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DimensionName").getter(DimensionFilter.getter(DimensionFilter::dimensionName)).setter(DimensionFilter.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()}).build();
    private static final SdkField<List<String>> DIMENSION_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionValueList").getter(DimensionFilter.getter(DimensionFilter::dimensionValueList)).setter(DimensionFilter.setter(Builder::dimensionValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD, DIMENSION_VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dimensionName;
    private final List<String> dimensionValueList;

    private DimensionFilter(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueList = builder.dimensionValueList;
    }

    public final String dimensionName() {
        return this.dimensionName;
    }

    public final boolean hasDimensionValueList() {
        return this.dimensionValueList != null && !(this.dimensionValueList instanceof SdkAutoConstructList);
    }

    public final List<String> dimensionValueList() {
        return this.dimensionValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionValueList() ? this.dimensionValueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionFilter)) {
            return false;
        }
        DimensionFilter other = (DimensionFilter)obj;
        return Objects.equals(this.dimensionName(), other.dimensionName()) && this.hasDimensionValueList() == other.hasDimensionValueList() && Objects.equals(this.dimensionValueList(), other.dimensionValueList());
    }

    public final String toString() {
        return ToString.builder((String)"DimensionFilter").add("DimensionName", (Object)this.dimensionName()).add("DimensionValueList", this.hasDimensionValueList() ? this.dimensionValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
            case "DimensionValueList": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionFilter, T> g) {
        return obj -> g.apply((DimensionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private List<String> dimensionValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionFilter model) {
            this.dimensionName(model.dimensionName);
            this.dimensionValueList(model.dimensionValueList);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final Collection<String> getDimensionValueList() {
            if (this.dimensionValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dimensionValueList;
        }

        public final void setDimensionValueList(Collection<String> dimensionValueList) {
            this.dimensionValueList = DimensionValueListCopier.copy(dimensionValueList);
        }

        @Override
        public final Builder dimensionValueList(Collection<String> dimensionValueList) {
            this.dimensionValueList = DimensionValueListCopier.copy(dimensionValueList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueList(String ... dimensionValueList) {
            this.dimensionValueList(Arrays.asList(dimensionValueList));
            return this;
        }

        public DimensionFilter build() {
            return new DimensionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionFilter> {
        public Builder dimensionName(String var1);

        public Builder dimensionValueList(Collection<String> var1);

        public Builder dimensionValueList(String ... var1);
    }
}

