/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutmetrics.model.ContributionMatrix;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricLevelImpact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricLevelImpact> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricLevelImpact.getter(MetricLevelImpact::metricName)).setter(MetricLevelImpact.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<Integer> NUM_TIME_SERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumTimeSeries").getter(MetricLevelImpact.getter(MetricLevelImpact::numTimeSeries)).setter(MetricLevelImpact.setter(Builder::numTimeSeries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumTimeSeries").build()}).build();
    private static final SdkField<ContributionMatrix> CONTRIBUTION_MATRIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContributionMatrix").getter(MetricLevelImpact.getter(MetricLevelImpact::contributionMatrix)).setter(MetricLevelImpact.setter(Builder::contributionMatrix)).constructor(ContributionMatrix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionMatrix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, NUM_TIME_SERIES_FIELD, CONTRIBUTION_MATRIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricLevelImpact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricName;
    private final Integer numTimeSeries;
    private final ContributionMatrix contributionMatrix;

    private MetricLevelImpact(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.numTimeSeries = builder.numTimeSeries;
        this.contributionMatrix = builder.contributionMatrix;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final Integer numTimeSeries() {
        return this.numTimeSeries;
    }

    public final ContributionMatrix contributionMatrix() {
        return this.contributionMatrix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numTimeSeries());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributionMatrix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricLevelImpact)) {
            return false;
        }
        MetricLevelImpact other = (MetricLevelImpact)obj;
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.numTimeSeries(), other.numTimeSeries()) && Objects.equals(this.contributionMatrix(), other.contributionMatrix());
    }

    public final String toString() {
        return ToString.builder((String)"MetricLevelImpact").add("MetricName", (Object)this.metricName()).add("NumTimeSeries", (Object)this.numTimeSeries()).add("ContributionMatrix", (Object)this.contributionMatrix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "NumTimeSeries": {
                return Optional.ofNullable(clazz.cast(this.numTimeSeries()));
            }
            case "ContributionMatrix": {
                return Optional.ofNullable(clazz.cast(this.contributionMatrix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("NumTimeSeries", NUM_TIME_SERIES_FIELD);
        map.put("ContributionMatrix", CONTRIBUTION_MATRIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricLevelImpact, T> g) {
        return obj -> g.apply((MetricLevelImpact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private Integer numTimeSeries;
        private ContributionMatrix contributionMatrix;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricLevelImpact model) {
            this.metricName(model.metricName);
            this.numTimeSeries(model.numTimeSeries);
            this.contributionMatrix(model.contributionMatrix);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Integer getNumTimeSeries() {
            return this.numTimeSeries;
        }

        public final void setNumTimeSeries(Integer numTimeSeries) {
            this.numTimeSeries = numTimeSeries;
        }

        @Override
        public final Builder numTimeSeries(Integer numTimeSeries) {
            this.numTimeSeries = numTimeSeries;
            return this;
        }

        public final ContributionMatrix.Builder getContributionMatrix() {
            return this.contributionMatrix != null ? this.contributionMatrix.toBuilder() : null;
        }

        public final void setContributionMatrix(ContributionMatrix.BuilderImpl contributionMatrix) {
            this.contributionMatrix = contributionMatrix != null ? contributionMatrix.build() : null;
        }

        @Override
        public final Builder contributionMatrix(ContributionMatrix contributionMatrix) {
            this.contributionMatrix = contributionMatrix;
            return this;
        }

        public MetricLevelImpact build() {
            return new MetricLevelImpact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricLevelImpact> {
        public Builder metricName(String var1);

        public Builder numTimeSeries(Integer var1);

        public Builder contributionMatrix(ContributionMatrix var1);

        default public Builder contributionMatrix(Consumer<ContributionMatrix.Builder> contributionMatrix) {
            return this.contributionMatrix((ContributionMatrix)((ContributionMatrix.Builder)ContributionMatrix.builder().applyMutation(contributionMatrix)).build());
        }
    }
}

