/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.machinelearning.model.BatchPrediction;
import software.amazon.awssdk.services.machinelearning.model.BatchPredictionsCopier;
import software.amazon.awssdk.services.machinelearning.model.MachineLearningResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBatchPredictionsResponse
extends MachineLearningResponse
implements ToCopyableBuilder<Builder, DescribeBatchPredictionsResponse> {
    private static final SdkField<List<BatchPrediction>> RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Results").getter(DescribeBatchPredictionsResponse.getter(DescribeBatchPredictionsResponse::results)).setter(DescribeBatchPredictionsResponse.setter(Builder::results)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Results").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPrediction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeBatchPredictionsResponse.getter(DescribeBatchPredictionsResponse::nextToken)).setter(DescribeBatchPredictionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BatchPrediction> results;
    private final String nextToken;

    private DescribeBatchPredictionsResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
        this.nextToken = builder.nextToken;
    }

    public boolean hasResults() {
        return this.results != null && !(this.results instanceof SdkAutoConstructList);
    }

    public List<BatchPrediction> results() {
        return this.results;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResults() ? this.results() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchPredictionsResponse)) {
            return false;
        }
        DescribeBatchPredictionsResponse other = (DescribeBatchPredictionsResponse)((Object)obj);
        return this.hasResults() == other.hasResults() && Objects.equals(this.results(), other.results()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeBatchPredictionsResponse").add("Results", this.hasResults() ? this.results() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Results": {
                return Optional.ofNullable(clazz.cast(this.results()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchPredictionsResponse, T> g) {
        return obj -> g.apply((DescribeBatchPredictionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MachineLearningResponse.BuilderImpl
    implements Builder {
        private List<BatchPrediction> results = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchPredictionsResponse model) {
            super(model);
            this.results(model.results);
            this.nextToken(model.nextToken);
        }

        public final Collection<BatchPrediction.Builder> getResults() {
            if (this.results instanceof SdkAutoConstructList) {
                return null;
            }
            return this.results != null ? (Collection)this.results.stream().map(BatchPrediction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder results(Collection<BatchPrediction> results) {
            this.results = BatchPredictionsCopier.copy(results);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(BatchPrediction ... results) {
            this.results(Arrays.asList(results));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder results(Consumer<BatchPrediction.Builder> ... results) {
            this.results(Stream.of(results).map(c -> (BatchPrediction)((BatchPrediction.Builder)BatchPrediction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResults(Collection<BatchPrediction.BuilderImpl> results) {
            this.results = BatchPredictionsCopier.copyFromBuilder(results);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeBatchPredictionsResponse build() {
            return new DescribeBatchPredictionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MachineLearningResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBatchPredictionsResponse> {
        public Builder results(Collection<BatchPrediction> var1);

        public Builder results(BatchPrediction ... var1);

        public Builder results(Consumer<BatchPrediction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

