/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.machinelearning.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.machinelearning.model.RDSDatabase;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RDSMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RDSMetadata> {
    private static final SdkField<RDSDatabase> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Database").getter(RDSMetadata.getter(RDSMetadata::database)).setter(RDSMetadata.setter(Builder::database)).constructor(RDSDatabase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DATABASE_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseUserName").getter(RDSMetadata.getter(RDSMetadata::databaseUserName)).setter(RDSMetadata.setter(Builder::databaseUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseUserName").build()}).build();
    private static final SdkField<String> SELECT_SQL_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectSqlQuery").getter(RDSMetadata.getter(RDSMetadata::selectSqlQuery)).setter(RDSMetadata.setter(Builder::selectSqlQuery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectSqlQuery").build()}).build();
    private static final SdkField<String> RESOURCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceRole").getter(RDSMetadata.getter(RDSMetadata::resourceRole)).setter(RDSMetadata.setter(Builder::resourceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRole").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRole").getter(RDSMetadata.getter(RDSMetadata::serviceRole)).setter(RDSMetadata.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()}).build();
    private static final SdkField<String> DATA_PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataPipelineId").getter(RDSMetadata.getter(RDSMetadata::dataPipelineId)).setter(RDSMetadata.setter(Builder::dataPipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPipelineId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, DATABASE_USER_NAME_FIELD, SELECT_SQL_QUERY_FIELD, RESOURCE_ROLE_FIELD, SERVICE_ROLE_FIELD, DATA_PIPELINE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final RDSDatabase database;
    private final String databaseUserName;
    private final String selectSqlQuery;
    private final String resourceRole;
    private final String serviceRole;
    private final String dataPipelineId;

    private RDSMetadata(BuilderImpl builder) {
        this.database = builder.database;
        this.databaseUserName = builder.databaseUserName;
        this.selectSqlQuery = builder.selectSqlQuery;
        this.resourceRole = builder.resourceRole;
        this.serviceRole = builder.serviceRole;
        this.dataPipelineId = builder.dataPipelineId;
    }

    public RDSDatabase database() {
        return this.database;
    }

    public String databaseUserName() {
        return this.databaseUserName;
    }

    public String selectSqlQuery() {
        return this.selectSqlQuery;
    }

    public String resourceRole() {
        return this.resourceRole;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public String dataPipelineId() {
        return this.dataPipelineId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectSqlQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPipelineId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDSMetadata)) {
            return false;
        }
        RDSMetadata other = (RDSMetadata)obj;
        return Objects.equals(this.database(), other.database()) && Objects.equals(this.databaseUserName(), other.databaseUserName()) && Objects.equals(this.selectSqlQuery(), other.selectSqlQuery()) && Objects.equals(this.resourceRole(), other.resourceRole()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.dataPipelineId(), other.dataPipelineId());
    }

    public String toString() {
        return ToString.builder((String)"RDSMetadata").add("Database", (Object)this.database()).add("DatabaseUserName", (Object)this.databaseUserName()).add("SelectSqlQuery", (Object)this.selectSqlQuery()).add("ResourceRole", (Object)this.resourceRole()).add("ServiceRole", (Object)this.serviceRole()).add("DataPipelineId", (Object)this.dataPipelineId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DatabaseUserName": {
                return Optional.ofNullable(clazz.cast(this.databaseUserName()));
            }
            case "SelectSqlQuery": {
                return Optional.ofNullable(clazz.cast(this.selectSqlQuery()));
            }
            case "ResourceRole": {
                return Optional.ofNullable(clazz.cast(this.resourceRole()));
            }
            case "ServiceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "DataPipelineId": {
                return Optional.ofNullable(clazz.cast(this.dataPipelineId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RDSMetadata, T> g) {
        return obj -> g.apply((RDSMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RDSDatabase database;
        private String databaseUserName;
        private String selectSqlQuery;
        private String resourceRole;
        private String serviceRole;
        private String dataPipelineId;

        private BuilderImpl() {
        }

        private BuilderImpl(RDSMetadata model) {
            this.database(model.database);
            this.databaseUserName(model.databaseUserName);
            this.selectSqlQuery(model.selectSqlQuery);
            this.resourceRole(model.resourceRole);
            this.serviceRole(model.serviceRole);
            this.dataPipelineId(model.dataPipelineId);
        }

        public final RDSDatabase.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        @Override
        public final Builder database(RDSDatabase database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(RDSDatabase.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        public final String getDatabaseUserName() {
            return this.databaseUserName;
        }

        @Override
        public final Builder databaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
            return this;
        }

        public final void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public final String getSelectSqlQuery() {
            return this.selectSqlQuery;
        }

        @Override
        public final Builder selectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
            return this;
        }

        public final void setSelectSqlQuery(String selectSqlQuery) {
            this.selectSqlQuery = selectSqlQuery;
        }

        public final String getResourceRole() {
            return this.resourceRole;
        }

        @Override
        public final Builder resourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
            return this;
        }

        public final void setResourceRole(String resourceRole) {
            this.resourceRole = resourceRole;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getDataPipelineId() {
            return this.dataPipelineId;
        }

        @Override
        public final Builder dataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
            return this;
        }

        public final void setDataPipelineId(String dataPipelineId) {
            this.dataPipelineId = dataPipelineId;
        }

        public RDSMetadata build() {
            return new RDSMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RDSMetadata> {
        public Builder database(RDSDatabase var1);

        default public Builder database(Consumer<RDSDatabase.Builder> database) {
            return this.database((RDSDatabase)((RDSDatabase.Builder)RDSDatabase.builder().applyMutation(database)).build());
        }

        public Builder databaseUserName(String var1);

        public Builder selectSqlQuery(String var1);

        public Builder resourceRole(String var1);

        public Builder serviceRole(String var1);

        public Builder dataPipelineId(String var1);
    }
}

