/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateS3ResourcesResponse extends MacieResponse implements
        ToCopyableBuilder<AssociateS3ResourcesResponse.Builder, AssociateS3ResourcesResponse> {
    private static final SdkField<List<FailedS3Resource>> FAILED_S3_RESOURCES_FIELD = SdkField
            .<List<FailedS3Resource>> builder(MarshallingType.LIST)
            .getter(getter(AssociateS3ResourcesResponse::failedS3Resources))
            .setter(setter(Builder::failedS3Resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedS3Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedS3Resource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedS3Resource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_S3_RESOURCES_FIELD));

    private final List<FailedS3Resource> failedS3Resources;

    private AssociateS3ResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.failedS3Resources = builder.failedS3Resources;
    }

    /**
     * Returns true if the FailedS3Resources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasFailedS3Resources() {
        return failedS3Resources != null && !(failedS3Resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are provided for
     * each failed item.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailedS3Resources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are
     *         provided for each failed item.
     */
    public List<FailedS3Resource> failedS3Resources() {
        return failedS3Resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedS3Resources());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateS3ResourcesResponse)) {
            return false;
        }
        AssociateS3ResourcesResponse other = (AssociateS3ResourcesResponse) obj;
        return Objects.equals(failedS3Resources(), other.failedS3Resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateS3ResourcesResponse").add("FailedS3Resources", failedS3Resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failedS3Resources":
            return Optional.ofNullable(clazz.cast(failedS3Resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateS3ResourcesResponse, T> g) {
        return obj -> g.apply((AssociateS3ResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssociateS3ResourcesResponse> {
        /**
         * <p>
         * S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are provided
         * for each failed item.
         * </p>
         * 
         * @param failedS3Resources
         *        S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are
         *        provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedS3Resources(Collection<FailedS3Resource> failedS3Resources);

        /**
         * <p>
         * S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are provided
         * for each failed item.
         * </p>
         * 
         * @param failedS3Resources
         *        S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are
         *        provided for each failed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedS3Resources(FailedS3Resource... failedS3Resources);

        /**
         * <p>
         * S3 resources that couldn't be associated with Amazon Macie. An error code and an error message are provided
         * for each failed item.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FailedS3Resource>.Builder} avoiding the
         * need to create one manually via {@link List<FailedS3Resource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedS3Resource>.Builder#build()} is called immediately and
         * its result is passed to {@link #failedS3Resources(List<FailedS3Resource>)}.
         * 
         * @param failedS3Resources
         *        a consumer that will call methods on {@link List<FailedS3Resource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedS3Resources(List<FailedS3Resource>)
         */
        Builder failedS3Resources(Consumer<FailedS3Resource.Builder>... failedS3Resources);
    }

    static final class BuilderImpl extends MacieResponse.BuilderImpl implements Builder {
        private List<FailedS3Resource> failedS3Resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateS3ResourcesResponse model) {
            super(model);
            failedS3Resources(model.failedS3Resources);
        }

        public final Collection<FailedS3Resource.Builder> getFailedS3Resources() {
            return failedS3Resources != null ? failedS3Resources.stream().map(FailedS3Resource::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedS3Resources(Collection<FailedS3Resource> failedS3Resources) {
            this.failedS3Resources = FailedS3ResourcesCopier.copy(failedS3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedS3Resources(FailedS3Resource... failedS3Resources) {
            failedS3Resources(Arrays.asList(failedS3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedS3Resources(Consumer<FailedS3Resource.Builder>... failedS3Resources) {
            failedS3Resources(Stream.of(failedS3Resources).map(c -> FailedS3Resource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFailedS3Resources(Collection<FailedS3Resource.BuilderImpl> failedS3Resources) {
            this.failedS3Resources = FailedS3ResourcesCopier.copyFromBuilder(failedS3Resources);
        }

        @Override
        public AssociateS3ResourcesResponse build() {
            return new AssociateS3ResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
