/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListS3ResourcesRequest extends MacieRequest implements
        ToCopyableBuilder<ListS3ResourcesRequest.Builder, ListS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListS3ResourcesRequest::memberAccountId)).setter(setter(Builder::memberAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListS3ResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListS3ResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String memberAccountId;

    private final String nextToken;

    private final Integer maxResults;

    private ListS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Macie member account ID whose associated S3 resources you want to list.
     * </p>
     * 
     * @return The Amazon Macie member account ID whose associated S3 resources you want to list.
     */
    public String memberAccountId() {
        return memberAccountId;
    }

    /**
     * <p>
     * Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources
     * action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the
     * previous response to continue listing data.
     * </p>
     * 
     * @return Use this parameter when paginating results. Set its value to null on your first call to the
     *         ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of
     *         nextToken from the previous response to continue listing data.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Use this parameter to indicate the maximum number of items that you want in the response. The default value is
     * 250.
     * </p>
     * 
     * @return Use this parameter to indicate the maximum number of items that you want in the response. The default
     *         value is 250.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListS3ResourcesRequest)) {
            return false;
        }
        ListS3ResourcesRequest other = (ListS3ResourcesRequest) obj;
        return Objects.equals(memberAccountId(), other.memberAccountId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListS3ResourcesRequest").add("MemberAccountId", memberAccountId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "memberAccountId":
            return Optional.ofNullable(clazz.cast(memberAccountId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListS3ResourcesRequest, T> g) {
        return obj -> g.apply((ListS3ResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MacieRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListS3ResourcesRequest> {
        /**
         * <p>
         * The Amazon Macie member account ID whose associated S3 resources you want to list.
         * </p>
         * 
         * @param memberAccountId
         *        The Amazon Macie member account ID whose associated S3 resources you want to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberAccountId(String memberAccountId);

        /**
         * <p>
         * Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources
         * action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the
         * previous response to continue listing data.
         * </p>
         * 
         * @param nextToken
         *        Use this parameter when paginating results. Set its value to null on your first call to the
         *        ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of
         *        nextToken from the previous response to continue listing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Use this parameter to indicate the maximum number of items that you want in the response. The default value
         * is 250.
         * </p>
         * 
         * @param maxResults
         *        Use this parameter to indicate the maximum number of items that you want in the response. The default
         *        value is 250.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MacieRequest.BuilderImpl implements Builder {
        private String memberAccountId;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListS3ResourcesRequest model) {
            super(model);
            memberAccountId(model.memberAccountId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getMemberAccountId() {
            return memberAccountId;
        }

        @Override
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListS3ResourcesRequest build() {
            return new ListS3ResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
