/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie.model.S3ContinuousClassificationType;
import software.amazon.awssdk.services.macie.model.S3OneTimeClassificationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassificationType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassificationType> {
    private static final SdkField<String> ONE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClassificationType.getter(ClassificationType::oneTimeAsString)).setter(ClassificationType.setter(Builder::oneTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oneTime").build()}).build();
    private static final SdkField<String> CONTINUOUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClassificationType.getter(ClassificationType::continuousAsString)).setter(ClassificationType.setter(Builder::continuous)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continuous").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONE_TIME_FIELD, CONTINUOUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String oneTime;
    private final String continuous;

    private ClassificationType(BuilderImpl builder) {
        this.oneTime = builder.oneTime;
        this.continuous = builder.continuous;
    }

    public S3OneTimeClassificationType oneTime() {
        return S3OneTimeClassificationType.fromValue(this.oneTime);
    }

    public String oneTimeAsString() {
        return this.oneTime;
    }

    public S3ContinuousClassificationType continuous() {
        return S3ContinuousClassificationType.fromValue(this.continuous);
    }

    public String continuousAsString() {
        return this.continuous;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.oneTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.continuousAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationType)) {
            return false;
        }
        ClassificationType other = (ClassificationType)obj;
        return Objects.equals(this.oneTimeAsString(), other.oneTimeAsString()) && Objects.equals(this.continuousAsString(), other.continuousAsString());
    }

    public String toString() {
        return ToString.builder((String)"ClassificationType").add("OneTime", (Object)this.oneTimeAsString()).add("Continuous", (Object)this.continuousAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "oneTime": {
                return Optional.ofNullable(clazz.cast(this.oneTimeAsString()));
            }
            case "continuous": {
                return Optional.ofNullable(clazz.cast(this.continuousAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClassificationType, T> g) {
        return obj -> g.apply((ClassificationType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String oneTime;
        private String continuous;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationType model) {
            this.oneTime(model.oneTime);
            this.continuous(model.continuous);
        }

        public final String getOneTimeAsString() {
            return this.oneTime;
        }

        @Override
        public final Builder oneTime(String oneTime) {
            this.oneTime = oneTime;
            return this;
        }

        @Override
        public final Builder oneTime(S3OneTimeClassificationType oneTime) {
            this.oneTime(oneTime == null ? null : oneTime.toString());
            return this;
        }

        public final void setOneTime(String oneTime) {
            this.oneTime = oneTime;
        }

        public final String getContinuousAsString() {
            return this.continuous;
        }

        @Override
        public final Builder continuous(String continuous) {
            this.continuous = continuous;
            return this;
        }

        @Override
        public final Builder continuous(S3ContinuousClassificationType continuous) {
            this.continuous(continuous == null ? null : continuous.toString());
            return this;
        }

        public final void setContinuous(String continuous) {
            this.continuous = continuous;
        }

        public ClassificationType build() {
            return new ClassificationType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassificationType> {
        public Builder oneTime(String var1);

        public Builder oneTime(S3OneTimeClassificationType var1);

        public Builder continuous(String var1);

        public Builder continuous(S3ContinuousClassificationType var1);
    }
}

