/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.AssetContract;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse;

public class ListAssetContractsPublisher
implements SdkPublisher<ListAssetContractsResponse> {
    private final ManagedBlockchainQueryAsyncClient client;
    private final ListAssetContractsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetContractsPublisher(ManagedBlockchainQueryAsyncClient client, ListAssetContractsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetContractsPublisher(ManagedBlockchainQueryAsyncClient client, ListAssetContractsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetContractsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetContractsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetContract> contracts() {
        Function<ListAssetContractsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contracts() != null) {
                return response.contracts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetContractsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetContractsResponseFetcher
    implements AsyncPageFetcher<ListAssetContractsResponse> {
        private ListAssetContractsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetContractsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetContractsResponse> nextPage(ListAssetContractsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetContractsPublisher.this.client.listAssetContracts(ListAssetContractsPublisher.this.firstRequest);
            }
            return ListAssetContractsPublisher.this.client.listAssetContracts((ListAssetContractsRequest)((Object)ListAssetContractsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

