/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for ancillary captions source.
 */
@Generated("software.amazon.awssdk:codegen")
public final class AncillarySourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AncillarySourceSettings.Builder, AncillarySourceSettings> {
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AncillarySourceSettings::convert608To708AsString)).setter(setter(Builder::convert608To708))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()).build();

    private static final SdkField<Integer> SOURCE_ANCILLARY_CHANNEL_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AncillarySourceSettings::sourceAncillaryChannelNumber))
            .setter(setter(Builder::sourceAncillaryChannelNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAncillaryChannelNumber")
                    .build()).build();

    private static final SdkField<String> TERMINATE_CAPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AncillarySourceSettings::terminateCaptionsAsString)).setter(setter(Builder::terminateCaptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminateCaptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERT608_TO708_FIELD,
            SOURCE_ANCILLARY_CHANNEL_NUMBER_FIELD, TERMINATE_CAPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String convert608To708;

    private final Integer sourceAncillaryChannelNumber;

    private final String terminateCaptions;

    private AncillarySourceSettings(BuilderImpl builder) {
        this.convert608To708 = builder.convert608To708;
        this.sourceAncillaryChannelNumber = builder.sourceAncillaryChannelNumber;
        this.terminateCaptions = builder.terminateCaptions;
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link AncillaryConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see AncillaryConvert608To708
     */
    public AncillaryConvert608To708 convert608To708() {
        return AncillaryConvert608To708.fromValue(convert608To708);
    }

    /**
     * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
     * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through using
     * the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #convert608To708}
     * will return {@link AncillaryConvert608To708#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #convert608To708AsString}.
     * </p>
     * 
     * @return Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
     *         choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data
     *         through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data
     *         into 708.
     * @see AncillaryConvert608To708
     */
    public String convert608To708AsString() {
        return convert608To708;
    }

    /**
     * Specifies the 608 channel number in the ancillary data track from which to extract captions. Unused for
     * passthrough.
     * 
     * @return Specifies the 608 channel number in the ancillary data track from which to extract captions. Unused for
     *         passthrough.
     */
    public Integer sourceAncillaryChannelNumber() {
        return sourceAncillaryChannelNumber;
    }

    /**
     * By default, the service terminates any unterminated captions at the end of each input. If you want the caption to
     * continue onto your next input, disable this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminateCaptions}
     * will return {@link AncillaryTerminateCaptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #terminateCaptionsAsString}.
     * </p>
     * 
     * @return By default, the service terminates any unterminated captions at the end of each input. If you want the
     *         caption to continue onto your next input, disable this setting.
     * @see AncillaryTerminateCaptions
     */
    public AncillaryTerminateCaptions terminateCaptions() {
        return AncillaryTerminateCaptions.fromValue(terminateCaptions);
    }

    /**
     * By default, the service terminates any unterminated captions at the end of each input. If you want the caption to
     * continue onto your next input, disable this setting.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #terminateCaptions}
     * will return {@link AncillaryTerminateCaptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #terminateCaptionsAsString}.
     * </p>
     * 
     * @return By default, the service terminates any unterminated captions at the end of each input. If you want the
     *         caption to continue onto your next input, disable this setting.
     * @see AncillaryTerminateCaptions
     */
    public String terminateCaptionsAsString() {
        return terminateCaptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAncillaryChannelNumber());
        hashCode = 31 * hashCode + Objects.hashCode(terminateCaptionsAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AncillarySourceSettings)) {
            return false;
        }
        AncillarySourceSettings other = (AncillarySourceSettings) obj;
        return Objects.equals(convert608To708AsString(), other.convert608To708AsString())
                && Objects.equals(sourceAncillaryChannelNumber(), other.sourceAncillaryChannelNumber())
                && Objects.equals(terminateCaptionsAsString(), other.terminateCaptionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AncillarySourceSettings").add("Convert608To708", convert608To708AsString())
                .add("SourceAncillaryChannelNumber", sourceAncillaryChannelNumber())
                .add("TerminateCaptions", terminateCaptionsAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Convert608To708":
            return Optional.ofNullable(clazz.cast(convert608To708AsString()));
        case "SourceAncillaryChannelNumber":
            return Optional.ofNullable(clazz.cast(sourceAncillaryChannelNumber()));
        case "TerminateCaptions":
            return Optional.ofNullable(clazz.cast(terminateCaptionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AncillarySourceSettings, T> g) {
        return obj -> g.apply((AncillarySourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AncillarySourceSettings> {
        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see AncillaryConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AncillaryConvert608To708
         */
        Builder convert608To708(String convert608To708);

        /**
         * Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you choose
         * Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608 data through
         * using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the 608 data into 708.
         * 
         * @param convert608To708
         *        Specify whether this set of input captions appears in your outputs in both 608 and 708 format. If you
         *        choose Upconvert (UPCONVERT), MediaConvert includes the captions data in two ways: it passes the 608
         *        data through using the 608 compatibility bytes fields of the 708 wrapper, and it also translates the
         *        608 data into 708.
         * @see AncillaryConvert608To708
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AncillaryConvert608To708
         */
        Builder convert608To708(AncillaryConvert608To708 convert608To708);

        /**
         * Specifies the 608 channel number in the ancillary data track from which to extract captions. Unused for
         * passthrough.
         * 
         * @param sourceAncillaryChannelNumber
         *        Specifies the 608 channel number in the ancillary data track from which to extract captions. Unused
         *        for passthrough.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAncillaryChannelNumber(Integer sourceAncillaryChannelNumber);

        /**
         * By default, the service terminates any unterminated captions at the end of each input. If you want the
         * caption to continue onto your next input, disable this setting.
         * 
         * @param terminateCaptions
         *        By default, the service terminates any unterminated captions at the end of each input. If you want the
         *        caption to continue onto your next input, disable this setting.
         * @see AncillaryTerminateCaptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AncillaryTerminateCaptions
         */
        Builder terminateCaptions(String terminateCaptions);

        /**
         * By default, the service terminates any unterminated captions at the end of each input. If you want the
         * caption to continue onto your next input, disable this setting.
         * 
         * @param terminateCaptions
         *        By default, the service terminates any unterminated captions at the end of each input. If you want the
         *        caption to continue onto your next input, disable this setting.
         * @see AncillaryTerminateCaptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AncillaryTerminateCaptions
         */
        Builder terminateCaptions(AncillaryTerminateCaptions terminateCaptions);
    }

    static final class BuilderImpl implements Builder {
        private String convert608To708;

        private Integer sourceAncillaryChannelNumber;

        private String terminateCaptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AncillarySourceSettings model) {
            convert608To708(model.convert608To708);
            sourceAncillaryChannelNumber(model.sourceAncillaryChannelNumber);
            terminateCaptions(model.terminateCaptions);
        }

        public final String getConvert608To708AsString() {
            return convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(AncillaryConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        public final Integer getSourceAncillaryChannelNumber() {
            return sourceAncillaryChannelNumber;
        }

        @Override
        public final Builder sourceAncillaryChannelNumber(Integer sourceAncillaryChannelNumber) {
            this.sourceAncillaryChannelNumber = sourceAncillaryChannelNumber;
            return this;
        }

        public final void setSourceAncillaryChannelNumber(Integer sourceAncillaryChannelNumber) {
            this.sourceAncillaryChannelNumber = sourceAncillaryChannelNumber;
        }

        public final String getTerminateCaptionsAsString() {
            return terminateCaptions;
        }

        @Override
        public final Builder terminateCaptions(String terminateCaptions) {
            this.terminateCaptions = terminateCaptions;
            return this;
        }

        @Override
        public final Builder terminateCaptions(AncillaryTerminateCaptions terminateCaptions) {
            this.terminateCaptions(terminateCaptions == null ? null : terminateCaptions.toString());
            return this;
        }

        public final void setTerminateCaptions(String terminateCaptions) {
            this.terminateCaptions = terminateCaptions;
        }

        @Override
        public AncillarySourceSettings build() {
            return new AncillarySourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
