/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Audio codec settings (CodecSettings) under (AudioDescriptions) contains the group of settings related to audio
 * encoding. The settings in this group vary depending on the value that you choose for Audio codec (Codec). For each
 * codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings
 * object pairs. * AAC, AacSettings * MP2, Mp2Settings * WAV, WavSettings * AIFF, AiffSettings * AC3, Ac3Settings *
 * EAC3, Eac3Settings * EAC3_ATMOS, Eac3AtmosSettings
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioCodecSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioCodecSettings.Builder, AudioCodecSettings> {
    private static final SdkField<AacSettings> AAC_SETTINGS_FIELD = SdkField.<AacSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::aacSettings)).setter(setter(Builder::aacSettings))
            .constructor(AacSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aacSettings").build()).build();

    private static final SdkField<Ac3Settings> AC3_SETTINGS_FIELD = SdkField.<Ac3Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::ac3Settings)).setter(setter(Builder::ac3Settings))
            .constructor(Ac3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ac3Settings").build()).build();

    private static final SdkField<AiffSettings> AIFF_SETTINGS_FIELD = SdkField.<AiffSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::aiffSettings)).setter(setter(Builder::aiffSettings))
            .constructor(AiffSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiffSettings").build()).build();

    private static final SdkField<String> CODEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AudioCodecSettings::codecAsString)).setter(setter(Builder::codec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()).build();

    private static final SdkField<Eac3AtmosSettings> EAC3_ATMOS_SETTINGS_FIELD = SdkField
            .<Eac3AtmosSettings> builder(MarshallingType.SDK_POJO).getter(getter(AudioCodecSettings::eac3AtmosSettings))
            .setter(setter(Builder::eac3AtmosSettings)).constructor(Eac3AtmosSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3AtmosSettings").build()).build();

    private static final SdkField<Eac3Settings> EAC3_SETTINGS_FIELD = SdkField.<Eac3Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::eac3Settings)).setter(setter(Builder::eac3Settings))
            .constructor(Eac3Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3Settings").build()).build();

    private static final SdkField<Mp2Settings> MP2_SETTINGS_FIELD = SdkField.<Mp2Settings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::mp2Settings)).setter(setter(Builder::mp2Settings))
            .constructor(Mp2Settings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp2Settings").build()).build();

    private static final SdkField<WavSettings> WAV_SETTINGS_FIELD = SdkField.<WavSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(AudioCodecSettings::wavSettings)).setter(setter(Builder::wavSettings))
            .constructor(WavSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wavSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AAC_SETTINGS_FIELD,
            AC3_SETTINGS_FIELD, AIFF_SETTINGS_FIELD, CODEC_FIELD, EAC3_ATMOS_SETTINGS_FIELD, EAC3_SETTINGS_FIELD,
            MP2_SETTINGS_FIELD, WAV_SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AacSettings aacSettings;

    private final Ac3Settings ac3Settings;

    private final AiffSettings aiffSettings;

    private final String codec;

    private final Eac3AtmosSettings eac3AtmosSettings;

    private final Eac3Settings eac3Settings;

    private final Mp2Settings mp2Settings;

    private final WavSettings wavSettings;

    private AudioCodecSettings(BuilderImpl builder) {
        this.aacSettings = builder.aacSettings;
        this.ac3Settings = builder.ac3Settings;
        this.aiffSettings = builder.aiffSettings;
        this.codec = builder.codec;
        this.eac3AtmosSettings = builder.eac3AtmosSettings;
        this.eac3Settings = builder.eac3Settings;
        this.mp2Settings = builder.mp2Settings;
        this.wavSettings = builder.wavSettings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts one
     * of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the value of
     * Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality with the
     * setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and valid values
     * depend on the rate control mode.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service
     *         accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes,
     *         set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the
     *         audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate
     *         (bitrate). Defaults and valid values depend on the rate control mode.
     */
    public AacSettings aacSettings() {
        return aacSettings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
     */
    public Ac3Settings ac3Settings() {
        return ac3Settings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
     */
    public AiffSettings aiffSettings() {
        return aiffSettings;
    }

    /**
     * Type of Audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link AudioCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Type of Audio codec.
     * @see AudioCodec
     */
    public AudioCodec codec() {
        return AudioCodec.fromValue(codec);
    }

    /**
     * Type of Audio codec.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #codec} will return
     * {@link AudioCodec#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #codecAsString}.
     * </p>
     * 
     * @return Type of Audio codec.
     * @see AudioCodec
     */
    public String codecAsString() {
        return codec;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
     */
    public Eac3AtmosSettings eac3AtmosSettings() {
        return eac3AtmosSettings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
     */
    public Eac3Settings eac3Settings() {
        return eac3Settings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
     */
    public Mp2Settings mp2Settings() {
        return mp2Settings;
    }

    /**
     * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
     * 
     * @return Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
     */
    public WavSettings wavSettings() {
        return wavSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(ac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(aiffSettings());
        hashCode = 31 * hashCode + Objects.hashCode(codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eac3AtmosSettings());
        hashCode = 31 * hashCode + Objects.hashCode(eac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(mp2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(wavSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecSettings)) {
            return false;
        }
        AudioCodecSettings other = (AudioCodecSettings) obj;
        return Objects.equals(aacSettings(), other.aacSettings()) && Objects.equals(ac3Settings(), other.ac3Settings())
                && Objects.equals(aiffSettings(), other.aiffSettings()) && Objects.equals(codecAsString(), other.codecAsString())
                && Objects.equals(eac3AtmosSettings(), other.eac3AtmosSettings())
                && Objects.equals(eac3Settings(), other.eac3Settings()) && Objects.equals(mp2Settings(), other.mp2Settings())
                && Objects.equals(wavSettings(), other.wavSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioCodecSettings").add("AacSettings", aacSettings()).add("Ac3Settings", ac3Settings())
                .add("AiffSettings", aiffSettings()).add("Codec", codecAsString()).add("Eac3AtmosSettings", eac3AtmosSettings())
                .add("Eac3Settings", eac3Settings()).add("Mp2Settings", mp2Settings()).add("WavSettings", wavSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AacSettings":
            return Optional.ofNullable(clazz.cast(aacSettings()));
        case "Ac3Settings":
            return Optional.ofNullable(clazz.cast(ac3Settings()));
        case "AiffSettings":
            return Optional.ofNullable(clazz.cast(aiffSettings()));
        case "Codec":
            return Optional.ofNullable(clazz.cast(codecAsString()));
        case "Eac3AtmosSettings":
            return Optional.ofNullable(clazz.cast(eac3AtmosSettings()));
        case "Eac3Settings":
            return Optional.ofNullable(clazz.cast(eac3Settings()));
        case "Mp2Settings":
            return Optional.ofNullable(clazz.cast(mp2Settings()));
        case "WavSettings":
            return Optional.ofNullable(clazz.cast(wavSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecSettings, T> g) {
        return obj -> g.apply((AudioCodecSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioCodecSettings> {
        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts
         * one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the
         * value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality
         * with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and
         * valid values depend on the rate control mode.
         * 
         * @param aacSettings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service
         *        accepts one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these
         *        modes, set the value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you
         *        control the audio quality with the setting VBR quality (vbrQuality). In CBR mode, you use the setting
         *        Bitrate (bitrate). Defaults and valid values depend on the rate control mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aacSettings(AacSettings aacSettings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AAC. The service accepts
         * one of two mutually exclusive groups of AAC settings--VBR and CBR. To select one of these modes, set the
         * value of Bitrate control mode (rateControlMode) to "VBR" or "CBR". In VBR mode, you control the audio quality
         * with the setting VBR quality (vbrQuality). In CBR mode, you use the setting Bitrate (bitrate). Defaults and
         * valid values depend on the rate control mode. This is a convenience that creates an instance of the
         * {@link AacSettings.Builder} avoiding the need to create one manually via {@link AacSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AacSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #aacSettings(AacSettings)}.
         * 
         * @param aacSettings
         *        a consumer that will call methods on {@link AacSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aacSettings(AacSettings)
         */
        default Builder aacSettings(Consumer<AacSettings.Builder> aacSettings) {
            return aacSettings(AacSettings.builder().applyMutation(aacSettings).build());
        }

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
         * 
         * @param ac3Settings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ac3Settings(Ac3Settings ac3Settings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AC3. This is a
         * convenience that creates an instance of the {@link Ac3Settings.Builder} avoiding the need to create one
         * manually via {@link Ac3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Ac3Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #ac3Settings(Ac3Settings)}.
         * 
         * @param ac3Settings
         *        a consumer that will call methods on {@link Ac3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ac3Settings(Ac3Settings)
         */
        default Builder ac3Settings(Consumer<Ac3Settings.Builder> ac3Settings) {
            return ac3Settings(Ac3Settings.builder().applyMutation(ac3Settings).build());
        }

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
         * 
         * @param aiffSettings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiffSettings(AiffSettings aiffSettings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value AIFF. This is a
         * convenience that creates an instance of the {@link AiffSettings.Builder} avoiding the need to create one
         * manually via {@link AiffSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AiffSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #aiffSettings(AiffSettings)}.
         * 
         * @param aiffSettings
         *        a consumer that will call methods on {@link AiffSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiffSettings(AiffSettings)
         */
        default Builder aiffSettings(Consumer<AiffSettings.Builder> aiffSettings) {
            return aiffSettings(AiffSettings.builder().applyMutation(aiffSettings).build());
        }

        /**
         * Type of Audio codec.
         * 
         * @param codec
         *        Type of Audio codec.
         * @see AudioCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioCodec
         */
        Builder codec(String codec);

        /**
         * Type of Audio codec.
         * 
         * @param codec
         *        Type of Audio codec.
         * @see AudioCodec
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioCodec
         */
        Builder codec(AudioCodec codec);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
         * 
         * @param eac3AtmosSettings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eac3AtmosSettings(Eac3AtmosSettings eac3AtmosSettings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3_ATMOS. This is a
         * convenience that creates an instance of the {@link Eac3AtmosSettings.Builder} avoiding the need to create one
         * manually via {@link Eac3AtmosSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eac3AtmosSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #eac3AtmosSettings(Eac3AtmosSettings)}.
         * 
         * @param eac3AtmosSettings
         *        a consumer that will call methods on {@link Eac3AtmosSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eac3AtmosSettings(Eac3AtmosSettings)
         */
        default Builder eac3AtmosSettings(Consumer<Eac3AtmosSettings.Builder> eac3AtmosSettings) {
            return eac3AtmosSettings(Eac3AtmosSettings.builder().applyMutation(eac3AtmosSettings).build());
        }

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
         * 
         * @param eac3Settings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eac3Settings(Eac3Settings eac3Settings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value EAC3. This is a
         * convenience that creates an instance of the {@link Eac3Settings.Builder} avoiding the need to create one
         * manually via {@link Eac3Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Eac3Settings.Builder#build()} is called immediately and its
         * result is passed to {@link #eac3Settings(Eac3Settings)}.
         * 
         * @param eac3Settings
         *        a consumer that will call methods on {@link Eac3Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eac3Settings(Eac3Settings)
         */
        default Builder eac3Settings(Consumer<Eac3Settings.Builder> eac3Settings) {
            return eac3Settings(Eac3Settings.builder().applyMutation(eac3Settings).build());
        }

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
         * 
         * @param mp2Settings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mp2Settings(Mp2Settings mp2Settings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value MP2. This is a
         * convenience that creates an instance of the {@link Mp2Settings.Builder} avoiding the need to create one
         * manually via {@link Mp2Settings#builder()}.
         *
         * When the {@link Consumer} completes, {@link Mp2Settings.Builder#build()} is called immediately and its result
         * is passed to {@link #mp2Settings(Mp2Settings)}.
         * 
         * @param mp2Settings
         *        a consumer that will call methods on {@link Mp2Settings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mp2Settings(Mp2Settings)
         */
        default Builder mp2Settings(Consumer<Mp2Settings.Builder> mp2Settings) {
            return mp2Settings(Mp2Settings.builder().applyMutation(mp2Settings).build());
        }

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
         * 
         * @param wavSettings
         *        Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wavSettings(WavSettings wavSettings);

        /**
         * Required when you set (Codec) under (AudioDescriptions)>(CodecSettings) to the value WAV. This is a
         * convenience that creates an instance of the {@link WavSettings.Builder} avoiding the need to create one
         * manually via {@link WavSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link WavSettings.Builder#build()} is called immediately and its result
         * is passed to {@link #wavSettings(WavSettings)}.
         * 
         * @param wavSettings
         *        a consumer that will call methods on {@link WavSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wavSettings(WavSettings)
         */
        default Builder wavSettings(Consumer<WavSettings.Builder> wavSettings) {
            return wavSettings(WavSettings.builder().applyMutation(wavSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AacSettings aacSettings;

        private Ac3Settings ac3Settings;

        private AiffSettings aiffSettings;

        private String codec;

        private Eac3AtmosSettings eac3AtmosSettings;

        private Eac3Settings eac3Settings;

        private Mp2Settings mp2Settings;

        private WavSettings wavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecSettings model) {
            aacSettings(model.aacSettings);
            ac3Settings(model.ac3Settings);
            aiffSettings(model.aiffSettings);
            codec(model.codec);
            eac3AtmosSettings(model.eac3AtmosSettings);
            eac3Settings(model.eac3Settings);
            mp2Settings(model.mp2Settings);
            wavSettings(model.wavSettings);
        }

        public final AacSettings.Builder getAacSettings() {
            return aacSettings != null ? aacSettings.toBuilder() : null;
        }

        @Override
        public final Builder aacSettings(AacSettings aacSettings) {
            this.aacSettings = aacSettings;
            return this;
        }

        public final void setAacSettings(AacSettings.BuilderImpl aacSettings) {
            this.aacSettings = aacSettings != null ? aacSettings.build() : null;
        }

        public final Ac3Settings.Builder getAc3Settings() {
            return ac3Settings != null ? ac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder ac3Settings(Ac3Settings ac3Settings) {
            this.ac3Settings = ac3Settings;
            return this;
        }

        public final void setAc3Settings(Ac3Settings.BuilderImpl ac3Settings) {
            this.ac3Settings = ac3Settings != null ? ac3Settings.build() : null;
        }

        public final AiffSettings.Builder getAiffSettings() {
            return aiffSettings != null ? aiffSettings.toBuilder() : null;
        }

        @Override
        public final Builder aiffSettings(AiffSettings aiffSettings) {
            this.aiffSettings = aiffSettings;
            return this;
        }

        public final void setAiffSettings(AiffSettings.BuilderImpl aiffSettings) {
            this.aiffSettings = aiffSettings != null ? aiffSettings.build() : null;
        }

        public final String getCodecAsString() {
            return codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(AudioCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        public final Eac3AtmosSettings.Builder getEac3AtmosSettings() {
            return eac3AtmosSettings != null ? eac3AtmosSettings.toBuilder() : null;
        }

        @Override
        public final Builder eac3AtmosSettings(Eac3AtmosSettings eac3AtmosSettings) {
            this.eac3AtmosSettings = eac3AtmosSettings;
            return this;
        }

        public final void setEac3AtmosSettings(Eac3AtmosSettings.BuilderImpl eac3AtmosSettings) {
            this.eac3AtmosSettings = eac3AtmosSettings != null ? eac3AtmosSettings.build() : null;
        }

        public final Eac3Settings.Builder getEac3Settings() {
            return eac3Settings != null ? eac3Settings.toBuilder() : null;
        }

        @Override
        public final Builder eac3Settings(Eac3Settings eac3Settings) {
            this.eac3Settings = eac3Settings;
            return this;
        }

        public final void setEac3Settings(Eac3Settings.BuilderImpl eac3Settings) {
            this.eac3Settings = eac3Settings != null ? eac3Settings.build() : null;
        }

        public final Mp2Settings.Builder getMp2Settings() {
            return mp2Settings != null ? mp2Settings.toBuilder() : null;
        }

        @Override
        public final Builder mp2Settings(Mp2Settings mp2Settings) {
            this.mp2Settings = mp2Settings;
            return this;
        }

        public final void setMp2Settings(Mp2Settings.BuilderImpl mp2Settings) {
            this.mp2Settings = mp2Settings != null ? mp2Settings.build() : null;
        }

        public final WavSettings.Builder getWavSettings() {
            return wavSettings != null ? wavSettings.toBuilder() : null;
        }

        @Override
        public final Builder wavSettings(WavSettings wavSettings) {
            this.wavSettings = wavSettings;
            return this;
        }

        public final void setWavSettings(WavSettings.BuilderImpl wavSettings) {
            this.wavSettings = wavSettings != null ? wavSettings.build() : null;
        }

        @Override
        public AudioCodecSettings build() {
            return new AudioCodecSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
