/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Group of Audio Selectors
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSelectorGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioSelectorGroup.Builder, AudioSelectorGroup> {
    private static final SdkField<List<String>> AUDIO_SELECTOR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AudioSelectorGroup::audioSelectorNames))
            .setter(setter(Builder::audioSelectorNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_SELECTOR_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> audioSelectorNames;

    private AudioSelectorGroup(BuilderImpl builder) {
        this.audioSelectorNames = builder.audioSelectorNames;
    }

    /**
     * Returns true if the AudioSelectorNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAudioSelectorNames() {
        return audioSelectorNames != null && !(audioSelectorNames instanceof SdkAutoConstructList);
    }

    /**
     * Name of an Audio Selector within the same input to include in the group. Audio selector names are standardized,
     * based on their order within the input (e.g., "Audio Selector 1"). The audio selector name parameter can be
     * repeated to add any number of audio selectors to the group.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAudioSelectorNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Name of an Audio Selector within the same input to include in the group. Audio selector names are
     *         standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector name
     *         parameter can be repeated to add any number of audio selectors to the group.
     */
    public List<String> audioSelectorNames() {
        return audioSelectorNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioSelectorNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelectorGroup)) {
            return false;
        }
        AudioSelectorGroup other = (AudioSelectorGroup) obj;
        return Objects.equals(audioSelectorNames(), other.audioSelectorNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AudioSelectorGroup").add("AudioSelectorNames", audioSelectorNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioSelectorNames":
            return Optional.ofNullable(clazz.cast(audioSelectorNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioSelectorGroup, T> g) {
        return obj -> g.apply((AudioSelectorGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSelectorGroup> {
        /**
         * Name of an Audio Selector within the same input to include in the group. Audio selector names are
         * standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector name
         * parameter can be repeated to add any number of audio selectors to the group.
         * 
         * @param audioSelectorNames
         *        Name of an Audio Selector within the same input to include in the group. Audio selector names are
         *        standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector
         *        name parameter can be repeated to add any number of audio selectors to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectorNames(Collection<String> audioSelectorNames);

        /**
         * Name of an Audio Selector within the same input to include in the group. Audio selector names are
         * standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector name
         * parameter can be repeated to add any number of audio selectors to the group.
         * 
         * @param audioSelectorNames
         *        Name of an Audio Selector within the same input to include in the group. Audio selector names are
         *        standardized, based on their order within the input (e.g., "Audio Selector 1"). The audio selector
         *        name parameter can be repeated to add any number of audio selectors to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioSelectorNames(String... audioSelectorNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> audioSelectorNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelectorGroup model) {
            audioSelectorNames(model.audioSelectorNames);
        }

        public final Collection<String> getAudioSelectorNames() {
            return audioSelectorNames;
        }

        @Override
        public final Builder audioSelectorNames(Collection<String> audioSelectorNames) {
            this.audioSelectorNames = ___listOf__stringMin1Copier.copy(audioSelectorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioSelectorNames(String... audioSelectorNames) {
            audioSelectorNames(Arrays.asList(audioSelectorNames));
            return this;
        }

        public final void setAudioSelectorNames(Collection<String> audioSelectorNames) {
            this.audioSelectorNames = ___listOf__stringMin1Copier.copy(audioSelectorNames);
        }

        @Override
        public AudioSelectorGroup build() {
            return new AudioSelectorGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
