/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQueueRequest extends MediaConvertRequest implements
        ToCopyableBuilder<CreateQueueRequest.Builder, CreateQueueRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQueueRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQueueRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQueueRequest::pricingPlanAsString)).setter(setter(Builder::pricingPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingPlan").build()).build();

    private static final SdkField<ReservationPlanSettings> RESERVATION_PLAN_SETTINGS_FIELD = SdkField
            .<ReservationPlanSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateQueueRequest::reservationPlanSettings)).setter(setter(Builder::reservationPlanSettings))
            .constructor(ReservationPlanSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPlanSettings").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateQueueRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateQueueRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD,
            PRICING_PLAN_FIELD, RESERVATION_PLAN_SETTINGS_FIELD, STATUS_FIELD, TAGS_FIELD));

    private final String description;

    private final String name;

    private final String pricingPlan;

    private final ReservationPlanSettings reservationPlanSettings;

    private final String status;

    private final Map<String, String> tags;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.pricingPlan = builder.pricingPlan;
        this.reservationPlanSettings = builder.reservationPlanSettings;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * Optional. A description of the queue that you are creating.
     * 
     * @return Optional. A description of the queue that you are creating.
     */
    public String description() {
        return description;
    }

    /**
     * The name of the queue that you are creating.
     * 
     * @return The name of the queue that you are creating.
     */
    public String name() {
        return name;
    }

    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
     * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
     * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use
     * the API to create a queue, the default is on-demand.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
     *         minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
     *         entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
     *         commitment. When you use the API to create a queue, the default is on-demand.
     * @see PricingPlan
     */
    public PricingPlan pricingPlan() {
        return PricingPlan.fromValue(pricingPlan);
    }

    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
     * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
     * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use
     * the API to create a queue, the default is on-demand.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pricingPlan} will
     * return {@link PricingPlan#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pricingPlanAsString}.
     * </p>
     * 
     * @return Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
     *         minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
     *         entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
     *         commitment. When you use the API to create a queue, the default is on-demand.
     * @see PricingPlan
     */
    public String pricingPlanAsString() {
        return pricingPlan;
    }

    /**
     * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
     * on-demand queues.
     * 
     * @return Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable
     *         to on-demand queues.
     */
    public ReservationPlanSettings reservationPlanSettings() {
        return reservationPlanSettings;
    }

    /**
     * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
     * @see QueueStatus
     */
    public QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
     * @see QueueStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a
     *         key.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reservationPlanSettings());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(pricingPlanAsString(), other.pricingPlanAsString())
                && Objects.equals(reservationPlanSettings(), other.reservationPlanSettings())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateQueueRequest").add("Description", description()).add("Name", name())
                .add("PricingPlan", pricingPlanAsString()).add("ReservationPlanSettings", reservationPlanSettings())
                .add("Status", statusAsString()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PricingPlan":
            return Optional.ofNullable(clazz.cast(pricingPlanAsString()));
        case "ReservationPlanSettings":
            return Optional.ofNullable(clazz.cast(reservationPlanSettings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQueueRequest, T> g) {
        return obj -> g.apply((CreateQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateQueueRequest> {
        /**
         * Optional. A description of the queue that you are creating.
         * 
         * @param description
         *        Optional. A description of the queue that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The name of the queue that you are creating.
         * 
         * @param name
         *        The name of the queue that you are creating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
         * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
         * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you
         * use the API to create a queue, the default is on-demand.
         * 
         * @param pricingPlan
         *        Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
         *        minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
         *        entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
         *        commitment. When you use the API to create a queue, the default is on-demand.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(String pricingPlan);

        /**
         * Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute,
         * billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue,
         * regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you
         * use the API to create a queue, the default is on-demand.
         * 
         * @param pricingPlan
         *        Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per
         *        minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the
         *        entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month
         *        commitment. When you use the API to create a queue, the default is on-demand.
         * @see PricingPlan
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PricingPlan
         */
        Builder pricingPlan(PricingPlan pricingPlan);

        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
         * on-demand queues.
         * 
         * @param reservationPlanSettings
         *        Details about the pricing plan for your reserved queue. Required for reserved queues and not
         *        applicable to on-demand queues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationPlanSettings(ReservationPlanSettings reservationPlanSettings);

        /**
         * Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to
         * on-demand queues. This is a convenience that creates an instance of the
         * {@link ReservationPlanSettings.Builder} avoiding the need to create one manually via
         * {@link ReservationPlanSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationPlanSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #reservationPlanSettings(ReservationPlanSettings)}.
         * 
         * @param reservationPlanSettings
         *        a consumer that will call methods on {@link ReservationPlanSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservationPlanSettings(ReservationPlanSettings)
         */
        default Builder reservationPlanSettings(Consumer<ReservationPlanSettings.Builder> reservationPlanSettings) {
            return reservationPlanSettings(ReservationPlanSettings.builder().applyMutation(reservationPlanSettings).build());
        }

        /**
         * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
         * 
         * @param status
         *        Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
         * 
         * @param status
         *        Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a
         * key.
         * 
         * @param tags
         *        The tags that you want to add to the resource. You can tag resources with a key-value pair or with
         *        only a key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private String description;

        private String name;

        private String pricingPlan;

        private ReservationPlanSettings reservationPlanSettings;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            description(model.description);
            name(model.name);
            pricingPlan(model.pricingPlan);
            reservationPlanSettings(model.reservationPlanSettings);
            status(model.status);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPricingPlanAsString() {
            return pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        public final ReservationPlanSettings.Builder getReservationPlanSettings() {
            return reservationPlanSettings != null ? reservationPlanSettings.toBuilder() : null;
        }

        @Override
        public final Builder reservationPlanSettings(ReservationPlanSettings reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings;
            return this;
        }

        public final void setReservationPlanSettings(ReservationPlanSettings.BuilderImpl reservationPlanSettings) {
            this.reservationPlanSettings = reservationPlanSettings != null ? reservationPlanSettings.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
