/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext.
 * These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must
 * match.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DvbSubtitleOutlineColor {
    BLACK("BLACK"),

    WHITE("WHITE"),

    YELLOW("YELLOW"),

    RED("RED"),

    GREEN("GREEN"),

    BLUE("BLUE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DvbSubtitleOutlineColor(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DvbSubtitleOutlineColor corresponding to the value
     */
    public static DvbSubtitleOutlineColor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DvbSubtitleOutlineColor.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DvbSubtitleOutlineColor}s
     */
    public static Set<DvbSubtitleOutlineColor> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
