/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * ESAM SignalProcessingNotification data defined by OC-SP-ESAM-API-I03-131025.
 */
@Generated("software.amazon.awssdk:codegen")
public final class EsamSignalProcessingNotification implements SdkPojo, Serializable,
        ToCopyableBuilder<EsamSignalProcessingNotification.Builder, EsamSignalProcessingNotification> {
    private static final SdkField<String> SCC_XML_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EsamSignalProcessingNotification::sccXml)).setter(setter(Builder::sccXml))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sccXml").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCC_XML_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sccXml;

    private EsamSignalProcessingNotification(BuilderImpl builder) {
        this.sccXml = builder.sccXml;
    }

    /**
     * Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. Form the XML document
     * as per OC-SP-ESAM-API-I03-131025. The transcoder will use the signal processing instructions in the message that
     * you supply. Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. For your
     * MPEG2-TS file outputs, if you want the service to place SCTE-35 markers at the insertion points you specify in
     * the XML document, you must also enable SCTE-35 ESAM (scte35Esam). Note that you can either specify an ESAM XML
     * document or enable SCTE-35 passthrough. You can't do both.
     * 
     * @return Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. Form the XML
     *         document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the signal processing instructions in
     *         the message that you supply. Provide your ESAM SignalProcessingNotification XML document inside your JSON
     *         job settings. For your MPEG2-TS file outputs, if you want the service to place SCTE-35 markers at the
     *         insertion points you specify in the XML document, you must also enable SCTE-35 ESAM (scte35Esam). Note
     *         that you can either specify an ESAM XML document or enable SCTE-35 passthrough. You can't do both.
     */
    public String sccXml() {
        return sccXml;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sccXml());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EsamSignalProcessingNotification)) {
            return false;
        }
        EsamSignalProcessingNotification other = (EsamSignalProcessingNotification) obj;
        return Objects.equals(sccXml(), other.sccXml());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EsamSignalProcessingNotification").add("SccXml", sccXml()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SccXml":
            return Optional.ofNullable(clazz.cast(sccXml()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EsamSignalProcessingNotification, T> g) {
        return obj -> g.apply((EsamSignalProcessingNotification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EsamSignalProcessingNotification> {
        /**
         * Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. Form the XML
         * document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the signal processing instructions in the
         * message that you supply. Provide your ESAM SignalProcessingNotification XML document inside your JSON job
         * settings. For your MPEG2-TS file outputs, if you want the service to place SCTE-35 markers at the insertion
         * points you specify in the XML document, you must also enable SCTE-35 ESAM (scte35Esam). Note that you can
         * either specify an ESAM XML document or enable SCTE-35 passthrough. You can't do both.
         * 
         * @param sccXml
         *        Provide your ESAM SignalProcessingNotification XML document inside your JSON job settings. Form the
         *        XML document as per OC-SP-ESAM-API-I03-131025. The transcoder will use the signal processing
         *        instructions in the message that you supply. Provide your ESAM SignalProcessingNotification XML
         *        document inside your JSON job settings. For your MPEG2-TS file outputs, if you want the service to
         *        place SCTE-35 markers at the insertion points you specify in the XML document, you must also enable
         *        SCTE-35 ESAM (scte35Esam). Note that you can either specify an ESAM XML document or enable SCTE-35
         *        passthrough. You can't do both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sccXml(String sccXml);
    }

    static final class BuilderImpl implements Builder {
        private String sccXml;

        private BuilderImpl() {
        }

        private BuilderImpl(EsamSignalProcessingNotification model) {
            sccXml(model.sccXml);
        }

        public final String getSccXml() {
            return sccXml;
        }

        @Override
        public final Builder sccXml(String sccXml) {
            this.sccXml = sccXml;
            return this;
        }

        public final void setSccXml(String sccXml) {
            this.sccXml = sccXml;
        }

        @Override
        public EsamSignalProcessingNotification build() {
            return new EsamSignalProcessingNotification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
