/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for quality-defined variable bitrate encoding with the H.264 codec. Required when you set Rate control mode
 * to QVBR. Not valid when you set Rate control mode to a value other than QVBR, or when you don't define Rate control
 * mode.
 */
@Generated("software.amazon.awssdk:codegen")
public final class H264QvbrSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<H264QvbrSettings.Builder, H264QvbrSettings> {
    private static final SdkField<Integer> MAX_AVERAGE_BITRATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264QvbrSettings::maxAverageBitrate)).setter(setter(Builder::maxAverageBitrate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAverageBitrate").build()).build();

    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(H264QvbrSettings::qvbrQualityLevel)).setter(setter(Builder::qvbrQualityLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_AVERAGE_BITRATE_FIELD,
            QVBR_QUALITY_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxAverageBitrate;

    private final Integer qvbrQualityLevel;

    private H264QvbrSettings(BuilderImpl builder) {
        this.maxAverageBitrate = builder.maxAverageBitrate;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
    }

    /**
     * Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average
     * bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video
     * part of this output to the value that you choose. That is, the total size of the video element is less than or
     * equal to the value you set multiplied by the number of seconds of encoded output.
     * 
     * @return Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max
     *         average bitrate values suited to the complexity of your input video, the service limits the average
     *         bitrate of the video part of this output to the value that you choose. That is, the total size of the
     *         video element is less than or equal to the value you set multiplied by the number of seconds of encoded
     *         output.
     */
    public Integer maxAverageBitrate() {
        return maxAverageBitrate;
    }

    /**
     * Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within h264Settings. Specify
     * the target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level 10 results
     * in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9.
     * 
     * @return Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within h264Settings.
     *         Specify the target quality level for this output, from 1 to 10. Use higher numbers for greater quality.
     *         Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes
     *         is between 6 and 9.
     */
    public Integer qvbrQualityLevel() {
        return qvbrQualityLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxAverageBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(qvbrQualityLevel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264QvbrSettings)) {
            return false;
        }
        H264QvbrSettings other = (H264QvbrSettings) obj;
        return Objects.equals(maxAverageBitrate(), other.maxAverageBitrate())
                && Objects.equals(qvbrQualityLevel(), other.qvbrQualityLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("H264QvbrSettings").add("MaxAverageBitrate", maxAverageBitrate())
                .add("QvbrQualityLevel", qvbrQualityLevel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxAverageBitrate":
            return Optional.ofNullable(clazz.cast(maxAverageBitrate()));
        case "QvbrQualityLevel":
            return Optional.ofNullable(clazz.cast(qvbrQualityLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264QvbrSettings, T> g) {
        return obj -> g.apply((H264QvbrSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, H264QvbrSettings> {
        /**
         * Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max
         * average bitrate values suited to the complexity of your input video, the service limits the average bitrate
         * of the video part of this output to the value that you choose. That is, the total size of the video element
         * is less than or equal to the value you set multiplied by the number of seconds of encoded output.
         * 
         * @param maxAverageBitrate
         *        Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For
         *        Max average bitrate values suited to the complexity of your input video, the service limits the
         *        average bitrate of the video part of this output to the value that you choose. That is, the total size
         *        of the video element is less than or equal to the value you set multiplied by the number of seconds of
         *        encoded output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAverageBitrate(Integer maxAverageBitrate);

        /**
         * Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within h264Settings.
         * Specify the target quality level for this output, from 1 to 10. Use higher numbers for greater quality. Level
         * 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between
         * 6 and 9.
         * 
         * @param qvbrQualityLevel
         *        Required when you use QVBR rate control mode. That is, when you specify qvbrSettings within
         *        h264Settings. Specify the target quality level for this output, from 1 to 10. Use higher numbers for
         *        greater quality. Level 10 results in nearly lossless compression. The quality level for most
         *        broadcast-quality transcodes is between 6 and 9.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qvbrQualityLevel(Integer qvbrQualityLevel);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxAverageBitrate;

        private Integer qvbrQualityLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(H264QvbrSettings model) {
            maxAverageBitrate(model.maxAverageBitrate);
            qvbrQualityLevel(model.qvbrQualityLevel);
        }

        public final Integer getMaxAverageBitrate() {
            return maxAverageBitrate;
        }

        @Override
        public final Builder maxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
            return this;
        }

        public final void setMaxAverageBitrate(Integer maxAverageBitrate) {
            this.maxAverageBitrate = maxAverageBitrate;
        }

        public final Integer getQvbrQualityLevel() {
            return qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public H264QvbrSettings build() {
            return new H264QvbrSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
