/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Choose the scan line type for the output. Choose Progressive (PROGRESSIVE) to create a progressive output, regardless
 * of the scan type of your input. Choose Top Field First (TOP_FIELD) or Bottom Field First (BOTTOM_FIELD) to create an
 * output that's interlaced with the same field polarity throughout. Choose Follow, Default Top (FOLLOW_TOP_FIELD) or
 * Follow, Default Bottom (FOLLOW_BOTTOM_FIELD) to create an interlaced output with the same field polarity as the
 * source. If the source is interlaced, the output will be interlaced with the same polarity as the source (it will
 * follow the source). The output could therefore be a mix of "top field first" and "bottom field first". If the source
 * is progressive, your output will be interlaced with "top field first" or "bottom field first" polarity, depending on
 * which of the Follow options you chose. If you don't choose a value, the service will default to Progressive
 * (PROGRESSIVE).
 */
@Generated("software.amazon.awssdk:codegen")
public enum H265InterlaceMode {
    PROGRESSIVE("PROGRESSIVE"),

    TOP_FIELD("TOP_FIELD"),

    BOTTOM_FIELD("BOTTOM_FIELD"),

    FOLLOW_TOP_FIELD("FOLLOW_TOP_FIELD"),

    FOLLOW_BOTTOM_FIELD("FOLLOW_BOTTOM_FIELD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private H265InterlaceMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return H265InterlaceMode corresponding to the value
     */
    public static H265InterlaceMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(H265InterlaceMode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link H265InterlaceMode}s
     */
    public static Set<H265InterlaceMode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
