/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobTemplatesRequest extends MediaConvertRequest implements
        ToCopyableBuilder<ListJobTemplatesRequest.Builder, ListJobTemplatesRequest> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobTemplatesRequest::category)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("category").build()).build();

    private static final SdkField<String> LIST_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobTemplatesRequest::listByAsString)).setter(setter(Builder::listBy))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("listBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListJobTemplatesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobTemplatesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListJobTemplatesRequest::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, LIST_BY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORDER_FIELD));

    private final String category;

    private final String listBy;

    private final Integer maxResults;

    private final String nextToken;

    private final String order;

    private ListJobTemplatesRequest(BuilderImpl builder) {
        super(builder);
        this.category = builder.category;
        this.listBy = builder.listBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.order = builder.order;
    }

    /**
     * Optionally, specify a job template category to limit responses to only job templates from that category.
     * 
     * @return Optionally, specify a job template category to limit responses to only job templates from that category.
     */
    public String category() {
        return category;
    }

    /**
     * Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
     * chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listBy} will
     * return {@link JobTemplateListBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listByAsString}.
     * </p>
     * 
     * @return Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
     *         chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
     * @see JobTemplateListBy
     */
    public JobTemplateListBy listBy() {
        return JobTemplateListBy.fromValue(listBy);
    }

    /**
     * Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
     * chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #listBy} will
     * return {@link JobTemplateListBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #listByAsString}.
     * </p>
     * 
     * @return Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
     *         chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
     * @see JobTemplateListBy
     */
    public String listByAsString() {
        return listBy;
    }

    /**
     * Optional. Number of job templates, up to twenty, that will be returned at one time.
     * 
     * @return Optional. Number of job templates, up to twenty, that will be returned at one time.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * Use this string, provided with the response to a previous request, to request the next batch of job templates.
     * 
     * @return Use this string, provided with the response to a previous request, to request the next batch of job
     *         templates.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
     * DESCENDING order. Default varies by resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
     *         DESCENDING order. Default varies by resource.
     * @see Order
     */
    public Order order() {
        return Order.fromValue(order);
    }

    /**
     * When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
     * DESCENDING order. Default varies by resource.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link Order#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
     *         DESCENDING order. Default varies by resource.
     * @see Order
     */
    public String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(category());
        hashCode = 31 * hashCode + Objects.hashCode(listByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobTemplatesRequest)) {
            return false;
        }
        ListJobTemplatesRequest other = (ListJobTemplatesRequest) obj;
        return Objects.equals(category(), other.category()) && Objects.equals(listByAsString(), other.listByAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListJobTemplatesRequest").add("Category", category()).add("ListBy", listByAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Order", orderAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "ListBy":
            return Optional.ofNullable(clazz.cast(listByAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobTemplatesRequest, T> g) {
        return obj -> g.apply((ListJobTemplatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaConvertRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobTemplatesRequest> {
        /**
         * Optionally, specify a job template category to limit responses to only job templates from that category.
         * 
         * @param category
         *        Optionally, specify a job template category to limit responses to only job templates from that
         *        category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String category);

        /**
         * Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
         * chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
         * 
         * @param listBy
         *        Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME
         *        or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
         * @see JobTemplateListBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateListBy
         */
        Builder listBy(String listBy);

        /**
         * Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or
         * chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
         * 
         * @param listBy
         *        Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME
         *        or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
         * @see JobTemplateListBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateListBy
         */
        Builder listBy(JobTemplateListBy listBy);

        /**
         * Optional. Number of job templates, up to twenty, that will be returned at one time.
         * 
         * @param maxResults
         *        Optional. Number of job templates, up to twenty, that will be returned at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Use this string, provided with the response to a previous request, to request the next batch of job
         * templates.
         * 
         * @param nextToken
         *        Use this string, provided with the response to a previous request, to request the next batch of job
         *        templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
         * DESCENDING order. Default varies by resource.
         * 
         * @param order
         *        When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING
         *        or DESCENDING order. Default varies by resource.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(String order);

        /**
         * When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING or
         * DESCENDING order. Default varies by resource.
         * 
         * @param order
         *        When you request lists of resources, you can optionally specify whether they are sorted in ASCENDING
         *        or DESCENDING order. Default varies by resource.
         * @see Order
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Order
         */
        Builder order(Order order);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaConvertRequest.BuilderImpl implements Builder {
        private String category;

        private String listBy;

        private Integer maxResults;

        private String nextToken;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobTemplatesRequest model) {
            super(model);
            category(model.category);
            listBy(model.listBy);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            order(model.order);
        }

        public final String getCategory() {
            return category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getListByAsString() {
            return listBy;
        }

        @Override
        public final Builder listBy(String listBy) {
            this.listBy = listBy;
            return this;
        }

        @Override
        public final Builder listBy(JobTemplateListBy listBy) {
            this.listBy(listBy == null ? null : listBy.toString());
            return this;
        }

        public final void setListBy(String listBy) {
            this.listBy = listBy;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOrderAsString() {
            return order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(Order order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobTemplatesRequest build() {
            return new ListJobTemplatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
