/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for MP4 segments in DASH
 */
@Generated("software.amazon.awssdk:codegen")
public final class MpdSettings implements SdkPojo, Serializable, ToCopyableBuilder<MpdSettings.Builder, MpdSettings> {
    private static final SdkField<String> CAPTION_CONTAINER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MpdSettings::captionContainerTypeAsString)).setter(setter(Builder::captionContainerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionContainerType").build())
            .build();

    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MpdSettings::scte35EsamAsString)).setter(setter(Builder::scte35Esam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()).build();

    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MpdSettings::scte35SourceAsString)).setter(setter(Builder::scte35Source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_CONTAINER_TYPE_FIELD,
            SCTE35_ESAM_FIELD, SCTE35_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String captionContainerType;

    private final String scte35Esam;

    private final String scte35Source;

    private MpdSettings(BuilderImpl builder) {
        this.captionContainerType = builder.captionContainerType;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
    }

    /**
     * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
     * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a
     * raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented
     * MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionContainerType} will return {@link MpdCaptionContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captionContainerTypeAsString}.
     * </p>
     * 
     * @return Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
     *         sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
     *         single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format
     *         contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and
     *         audio fragmented MP4 files.
     * @see MpdCaptionContainerType
     */
    public MpdCaptionContainerType captionContainerType() {
        return MpdCaptionContainerType.fromValue(captionContainerType);
    }

    /**
     * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
     * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file in a
     * raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within fragmented
     * MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4 files.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionContainerType} will return {@link MpdCaptionContainerType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #captionContainerTypeAsString}.
     * </p>
     * 
     * @return Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
     *         sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
     *         single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format
     *         contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your video and
     *         audio fragmented MP4 files.
     * @see MpdCaptionContainerType
     */
    public String captionContainerTypeAsString() {
        return captionContainerType;
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link MpdScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see MpdScte35Esam
     */
    public MpdScte35Esam scte35Esam() {
        return MpdScte35Esam.fromValue(scte35Esam);
    }

    /**
     * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in this
     * output at the insertion points that you specify in an ESAM XML document. Provide the document in the setting SCC
     * XML (sccXml).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Esam} will
     * return {@link MpdScte35Esam#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35EsamAsString}.
     * </p>
     * 
     * @return Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
     *         this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
     *         setting SCC XML (sccXml).
     * @see MpdScte35Esam
     */
    public String scte35EsamAsString() {
        return scte35Esam;
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link MpdScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see MpdScte35Source
     */
    public MpdScte35Source scte35Source() {
        return MpdScte35Source.fromValue(scte35Source);
    }

    /**
     * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough (PASSTHROUGH) if
     * you want SCTE-35 markers that appear in your input to also appear in this output. Choose None (NONE) if you don't
     * want those SCTE-35 markers in this output.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scte35Source} will
     * return {@link MpdScte35Source#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scte35SourceAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
     *         (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
     *         None (NONE) if you don't want those SCTE-35 markers in this output.
     * @see MpdScte35Source
     */
    public String scte35SourceAsString() {
        return scte35Source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(captionContainerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scte35SourceAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MpdSettings)) {
            return false;
        }
        MpdSettings other = (MpdSettings) obj;
        return Objects.equals(captionContainerTypeAsString(), other.captionContainerTypeAsString())
                && Objects.equals(scte35EsamAsString(), other.scte35EsamAsString())
                && Objects.equals(scte35SourceAsString(), other.scte35SourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MpdSettings").add("CaptionContainerType", captionContainerTypeAsString())
                .add("Scte35Esam", scte35EsamAsString()).add("Scte35Source", scte35SourceAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaptionContainerType":
            return Optional.ofNullable(clazz.cast(captionContainerTypeAsString()));
        case "Scte35Esam":
            return Optional.ofNullable(clazz.cast(scte35EsamAsString()));
        case "Scte35Source":
            return Optional.ofNullable(clazz.cast(scte35SourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MpdSettings, T> g) {
        return obj -> g.apply((MpdSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MpdSettings> {
        /**
         * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
         * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file
         * in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within
         * fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4
         * files.
         * 
         * @param captionContainerType
         *        Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
         *        sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
         *        single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML
         *        format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your
         *        video and audio fragmented MP4 files.
         * @see MpdCaptionContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdCaptionContainerType
         */
        Builder captionContainerType(String captionContainerType);

        /**
         * Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify sidecar
         * captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a single XML file
         * in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML format contained within
         * fragmented MP4 files. This set of fragmented MP4 files is separate from your video and audio fragmented MP4
         * files.
         * 
         * @param captionContainerType
         *        Use this setting only in DASH output groups that include sidecar TTML or IMSC captions. You specify
         *        sidecar captions in a separate output from your audio and video. Choose Raw (RAW) for captions in a
         *        single XML file in a raw container. Choose Fragmented MPEG-4 (FRAGMENTED_MP4) for captions in XML
         *        format contained within fragmented MP4 files. This set of fragmented MP4 files is separate from your
         *        video and audio fragmented MP4 files.
         * @see MpdCaptionContainerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdCaptionContainerType
         */
        Builder captionContainerType(MpdCaptionContainerType captionContainerType);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see MpdScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Esam
         */
        Builder scte35Esam(String scte35Esam);

        /**
         * Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers in
         * this output at the insertion points that you specify in an ESAM XML document. Provide the document in the
         * setting SCC XML (sccXml).
         * 
         * @param scte35Esam
         *        Use this setting only when you specify SCTE-35 markers from ESAM. Choose INSERT to put SCTE-35 markers
         *        in this output at the insertion points that you specify in an ESAM XML document. Provide the document
         *        in the setting SCC XML (sccXml).
         * @see MpdScte35Esam
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Esam
         */
        Builder scte35Esam(MpdScte35Esam scte35Esam);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see MpdScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Source
         */
        Builder scte35Source(String scte35Source);

        /**
         * Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         * (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output. Choose
         * None (NONE) if you don't want those SCTE-35 markers in this output.
         * 
         * @param scte35Source
         *        Ignore this setting unless you have SCTE-35 markers in your input video file. Choose Passthrough
         *        (PASSTHROUGH) if you want SCTE-35 markers that appear in your input to also appear in this output.
         *        Choose None (NONE) if you don't want those SCTE-35 markers in this output.
         * @see MpdScte35Source
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MpdScte35Source
         */
        Builder scte35Source(MpdScte35Source scte35Source);
    }

    static final class BuilderImpl implements Builder {
        private String captionContainerType;

        private String scte35Esam;

        private String scte35Source;

        private BuilderImpl() {
        }

        private BuilderImpl(MpdSettings model) {
            captionContainerType(model.captionContainerType);
            scte35Esam(model.scte35Esam);
            scte35Source(model.scte35Source);
        }

        public final String getCaptionContainerTypeAsString() {
            return captionContainerType;
        }

        @Override
        public final Builder captionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
            return this;
        }

        @Override
        public final Builder captionContainerType(MpdCaptionContainerType captionContainerType) {
            this.captionContainerType(captionContainerType == null ? null : captionContainerType.toString());
            return this;
        }

        public final void setCaptionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
        }

        public final String getScte35EsamAsString() {
            return scte35Esam;
        }

        @Override
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        public final Builder scte35Esam(MpdScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        public final String getScte35SourceAsString() {
            return scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(MpdScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        public MpdSettings build() {
            return new MpdSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
